/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.DeleteEachItemStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="deleteEachItem", description="Deletes in a loop each Document in a Query https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmoscontainer.deleteitem?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/delete-a-document\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/query-documents", priority=1, appliesTo={"container"})
public class DeleteEachItemChange
extends AbstractCosmosChange {
    private String containerId;
    private String query;

    public String getConfirmationMessage() {
        return "Items deleted in container: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        DeleteEachItemStatement deleteEachItemStatement = new DeleteEachItemStatement(this.containerId, this.query);
        return new SqlStatement[]{deleteEachItemStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getQuery() {
        return this.query;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

