/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.changelog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.ext.cosmosdb.changelog.CosmosRanChangeSet;
import liquibase.ext.cosmosdb.persistence.AbstractItemToDocumentConverter;

public class ChangeSetToDocumentConverter
extends AbstractItemToDocumentConverter<CosmosRanChangeSet, Map<String, Object>> {
    @Override
    public Map<String, Object> toDocument(CosmosRanChangeSet item) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put("id", item.getUuid());
        document.put("fileName", item.getChangeLog());
        document.put("changeSetId", item.getId());
        document.put("author", item.getAuthor());
        document.put("md5sum", Optional.ofNullable(item.getLastCheckSum()).map(CheckSum::toString).orElse(null));
        document.put("dateExecuted", Optional.ofNullable(item.getDateExecuted()).map(this::fromDate).orElse(null));
        document.put("tag", item.getTag());
        document.put("execType", Optional.ofNullable(item.getExecType()).map(e -> e.value).orElse(null));
        document.put("description", item.getDescription());
        document.put("comments", item.getComments());
        document.put("contexts", this.buildFullContext(item.getContextExpression(), item.getInheritableContexts()));
        document.put("labels", this.buildLabels(item.getLabels()));
        document.put("deploymentId", item.getDeploymentId());
        document.put("orderExecuted", item.getOrderExecuted());
        document.put("liquibase", item.getLiquibase());
        return document;
    }

    @Override
    public CosmosRanChangeSet fromDocument(Map<String, Object> document) {
        CosmosRanChangeSet item = new CosmosRanChangeSet((String)document.get("id"), (String)document.get("fileName"), (String)document.get("changeSetId"), (String)document.get("author"), CheckSum.parse((String)((String)document.get("md5sum"))), this.toDate((String)document.get("dateExecuted")), (String)document.get("tag"), Optional.ofNullable(document.get("execType")).map(s -> ChangeSet.ExecType.valueOf((String)((String)s))).orElse(null), (String)document.get("description"), (String)document.get("comments"), new ContextExpression((String)document.get("contexts")), null, new Labels((String)document.get("labels")), (String)document.get("deploymentId"), Optional.ofNullable(document.get("orderExecuted")).orElse(null), (String)document.get("liquibase"));
        return item;
    }

    public String buildLabels(Labels labels) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        return labels.toString();
    }

    public String buildFullContext(ContextExpression contextExpression, Collection<ContextExpression> inheritableContexts) {
        if (contextExpression == null || contextExpression.isEmpty()) {
            return null;
        }
        StringBuilder contextExpressionString = new StringBuilder();
        boolean notFirstContext = false;
        for (ContextExpression inheritableContext : inheritableContexts) {
            this.appendContext(contextExpressionString, inheritableContext.toString(), notFirstContext);
            notFirstContext = true;
        }
        this.appendContext(contextExpressionString, contextExpression.toString(), notFirstContext);
        return contextExpressionString.toString();
    }

    private void appendContext(StringBuilder contextExpression, String contextToAppend, boolean notFirstContext) {
        boolean complexExpression;
        boolean bl = complexExpression = contextToAppend.contains(",") || contextToAppend.contains(" ");
        if (notFirstContext) {
            contextExpression.append(" AND ");
        }
        if (complexExpression) {
            contextExpression.append("(");
        }
        contextExpression.append(contextToAppend);
        if (complexExpression) {
            contextExpression.append(")");
        }
    }
}

