/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.changelog;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.cosmosdb.changelog.CreateChangeLogContainerStatement;
import liquibase.ext.cosmosdb.changelog.GetNextChangeSetSequenceValueStatement;
import liquibase.ext.cosmosdb.changelog.MarkChangeSetRanStatement;
import liquibase.ext.cosmosdb.changelog.SelectChangeLogRanChangeSetsStatement;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CountContainersByNameStatement;
import liquibase.ext.cosmosdb.statement.CountDocumentsInContainerStatement;
import liquibase.ext.cosmosdb.statement.DeleteContainerStatement;
import liquibase.logging.Logger;
import liquibase.nosql.changelog.AbstractNoSqlHistoryService;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

public class CosmosHistoryService
extends AbstractNoSqlHistoryService<CosmosLiquibaseDatabase> {
    private final Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    public boolean supports(Database database) {
        return "Cosmos DB".equals(database.getDatabaseProductName());
    }

    @Override
    protected Boolean existsRepository() throws DatabaseException {
        return this.getExecutor().queryForLong((SqlStatement)new CountContainersByNameStatement(this.getDatabaseChangeLogTableName())) == 1L;
    }

    @Override
    protected void createRepository() throws DatabaseException {
        CreateChangeLogContainerStatement createChangeLogContainerStatement = new CreateChangeLogContainerStatement(this.getDatabaseChangeLogTableName());
        this.getExecutor().execute((SqlStatement)createChangeLogContainerStatement);
    }

    @Override
    protected void adjustRepository() throws DatabaseException {
    }

    @Override
    protected void dropRepository() throws DatabaseException {
        this.getExecutor().execute((SqlStatement)new DeleteContainerStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected List<RanChangeSet> queryRanChangeSets() throws DatabaseException {
        return this.getExecutor().queryForList((SqlStatement)new SelectChangeLogRanChangeSetsStatement(this.getDatabaseChangeLogTableName()), RanChangeSet.class).stream().map(RanChangeSet.class::cast).collect(Collectors.toList());
    }

    @Override
    protected Integer generateNextSequence() throws DatabaseException {
        return (int)this.getExecutor().queryForLong((SqlStatement)new GetNextChangeSetSequenceValueStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected void markChangeSetRun(ChangeSet changeSet, ChangeSet.ExecType execType, Integer nextSequenceValue) throws DatabaseException {
        NoSqlExecutor executor = this.getExecutor();
        MarkChangeSetRanStatement markChangeSetRanStatement = new MarkChangeSetRanStatement(this.getDatabaseChangeLogTableName(), changeSet, execType, nextSequenceValue, this.getDeploymentId());
        executor.execute((SqlStatement)markChangeSetRanStatement);
    }

    public String extractTag(ChangeSet changeSet) {
        String tag = null;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof TagDatabaseChange)) continue;
            TagDatabaseChange tagChange = (TagDatabaseChange)change;
            tag = StringUtil.trimToNull((String)tagChange.getTag());
        }
        return tag;
    }

    @Override
    protected void removeRanChangeSet(ChangeSet changeSet) throws DatabaseException {
    }

    @Override
    protected void clearChekSums() throws DatabaseException {
    }

    @Override
    protected long countTags(String tag) throws DatabaseException {
        return 0L;
    }

    @Override
    protected void tagLast(String tagString) throws DatabaseException {
    }

    @Override
    protected long countRanChangeSets() throws DatabaseException {
        return this.getExecutor().queryForLong((SqlStatement)new CountDocumentsInContainerStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected void updateCheckSum(ChangeSet changeSet) throws DatabaseException {
    }
}

