/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.changelog;

import java.util.Date;
import java.util.UUID;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.cosmosdb.changelog.ChangeSetRepository;
import liquibase.ext.cosmosdb.changelog.CosmosRanChangeSet;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class MarkChangeSetRanStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "markChangeSet";
    private final ChangeSet changeSet;
    private final ChangeSet.ExecType execType;
    private final Integer orderExecuted;
    private final String deploymentId;

    public MarkChangeSetRanStatement(String containerName, ChangeSet changeSet, ChangeSet.ExecType execType, Integer orderExecuted, String deploymentId) {
        super(containerName);
        this.changeSet = changeSet;
        this.execType = execType;
        this.orderExecuted = orderExecuted;
        this.deploymentId = deploymentId;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + this.containerName + ", " + this.changeSet + ", " + this.execType + ", " + this.orderExecuted + ", " + this.deploymentId + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        try {
            ChangeSetRepository repository = new ChangeSetRepository(database.getCosmosDatabase(), this.containerName);
            if (this.execType.equals((Object)ChangeSet.ExecType.FAILED) || this.execType.equals((Object)ChangeSet.ExecType.SKIPPED)) {
                return;
            }
            if (!this.execType.ranBefore) {
                CosmosRanChangeSet insertRanChangeSet = new CosmosRanChangeSet(UUID.randomUUID().toString(), this.changeSet.getFilePath(), this.changeSet.getId(), this.changeSet.getAuthor(), this.changeSet.generateCheckSum(), new Date(), this.extractTag(this.changeSet), this.execType, this.changeSet.getDescription(), this.changeSet.getComments(), this.changeSet.getContexts(), this.changeSet.getInheritableContexts(), this.changeSet.getLabels(), this.deploymentId, this.orderExecuted, LiquibaseUtil.getBuildVersion());
                repository.create(insertRanChangeSet);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public String extractTag(ChangeSet changeSet) {
        String tag = null;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof TagDatabaseChange)) continue;
            TagDatabaseChange tagChange = (TagDatabaseChange)change;
            tag = StringUtil.trimToNull((String)tagChange.getTag());
        }
        return tag;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public ChangeSet.ExecType getExecType() {
        return this.execType;
    }

    public Integer getOrderExecuted() {
        return this.orderExecuted;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }
}

