/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.changelog;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.changelog.RanChangeSet;
import liquibase.ext.cosmosdb.changelog.ChangeSetRepository;
import liquibase.ext.cosmosdb.changelog.CosmosRanChangeSet;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.nosql.statement.NoSqlQueryForListStatement;

public class SelectChangeLogRanChangeSetsStatement
extends AbstractCosmosContainerStatement
implements NoSqlQueryForListStatement<CosmosLiquibaseDatabase, CosmosRanChangeSet> {
    public static final String COMMAND_NAME = "selectRanChangeSets";

    public SelectChangeLogRanChangeSetsStatement(String containerName) {
        super(containerName);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public List<CosmosRanChangeSet> readAll(CosmosLiquibaseDatabase database) {
        ChangeSetRepository repository = new ChangeSetRepository(database.getCosmosDatabase(), this.getContainerName());
        return repository.getAll().stream().sorted(Comparator.comparing(RanChangeSet::getDateExecuted)).collect(Collectors.toList());
    }

    @Override
    public List<CosmosRanChangeSet> queryForList(CosmosLiquibaseDatabase database) {
        return this.readAll(database);
    }
}

