/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.database;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.Properties;
import java.util.logging.Logger;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.cosmosdb.database.CosmosClientProxy;
import liquibase.ext.cosmosdb.database.CosmosConnectionString;
import liquibase.util.StringUtil;

public class CosmosClientDriver
implements Driver {
    @Override
    public Connection connect(String url, Properties info) {
        throw new UnsupportedOperationException("Cannot initiate a SQL Connection for a NoSql DB");
    }

    public CosmosClientProxy connect(CosmosConnectionString cosmosConnectionString) throws DatabaseException {
        CosmosClient client;
        try {
            client = new CosmosClientBuilder().endpoint(cosmosConnectionString.getAccountEndpoint().orElse("")).key(cosmosConnectionString.getAccountKey().orElse("")).consistencyLevel(ConsistencyLevel.EVENTUAL).userAgentSuffix("LiquibaseExtension").buildClient();
        }
        catch (Exception e) {
            throw new DatabaseException("Connection could not be established to: " + cosmosConnectionString.getConnectionString(), (Throwable)e);
        }
        return CosmosClientProxy.builder().cosmosClient(client).build();
    }

    @Override
    public boolean acceptsURL(String url) {
        String trimmedUrl = StringUtil.trimToEmpty((String)url);
        return trimmedUrl.startsWith("cosmosdb://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return (Logger)Scope.getCurrentScope().getLog(this.getClass());
    }
}

