/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.database;

import com.azure.core.util.UrlBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.util.StringUtil;

public class CosmosConnectionString {
    public static final String ACCOUNT_ENDPOINT_PROPERTY = "accountEndpoint";
    public static final String ACCOUNT_KEY_PROPERTY = "accountKey";
    public static final String DATABASE_NAME_PROPERTY = "databaseName";
    public static final String COSMOSDB_PREFIX = "cosmosdb://";
    public static final String COSMOSDB_JSON_PREFIX = "cosmosdb://{";
    public static final String HTTPS_PREFIX = "https://";
    private final String connectionString;
    private final Map<String, String> properties;

    public String toUrl() {
        try {
            return COSMOSDB_PREFIX + JsonUtils.OBJECT_MAPPER.writer().writeValueAsString(this.properties);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not parse connection Json String: ", e);
        }
    }

    public static CosmosConnectionString fromConnectionString(String connectionString) {
        if (StringUtil.isEmpty((String)StringUtil.trimToNull((String)connectionString)) || !connectionString.startsWith(COSMOSDB_PREFIX)) {
            throw new IllegalArgumentException("connectionString should not be empty and has to start with: cosmosdb://");
        }
        if (connectionString.startsWith(COSMOSDB_JSON_PREFIX)) {
            return CosmosConnectionString.fromJsonConnectionString(connectionString);
        }
        return CosmosConnectionString.fromUrlConnectionString(connectionString);
    }

    public static CosmosConnectionString fromValues(String accountEndpoint, String accountKey, String databaseName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(ACCOUNT_ENDPOINT_PROPERTY, accountEndpoint);
        properties.put(ACCOUNT_KEY_PROPERTY, accountKey);
        properties.put(DATABASE_NAME_PROPERTY, databaseName);
        return new CosmosConnectionString(null, properties);
    }

    public static CosmosConnectionString fromJsonConnectionString(String jsonConnectionString) {
        if (StringUtil.isEmpty((String)StringUtil.trimToNull((String)jsonConnectionString)) || !jsonConnectionString.startsWith(COSMOSDB_JSON_PREFIX)) {
            throw new IllegalArgumentException("jsonConnectionString should not be empty and has to start with: cosmosdb://{");
        }
        try {
            String json = jsonConnectionString.replaceFirst(COSMOSDB_PREFIX, "");
            Map properties = (Map)JsonUtils.OBJECT_MAPPER.readValue(json, Map.class);
            return new CosmosConnectionString(jsonConnectionString, Optional.ofNullable(properties).orElse(Collections.emptyMap()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not parse connection Json String: ", e);
        }
    }

    public static CosmosConnectionString fromUrlConnectionString(String url) {
        if (StringUtil.isEmpty((String)StringUtil.trimToNull((String)url)) || !url.startsWith(COSMOSDB_PREFIX)) {
            throw new IllegalArgumentException("Url should not be empty and has to start with: cosmosdb://");
        }
        try {
            int beginIndex = url.indexOf(58, COSMOSDB_PREFIX.length());
            int endIndex = url.indexOf(64, beginIndex + 1);
            String accountKey = url.substring(beginIndex + 1, endIndex);
            String httpsUrl = HTTPS_PREFIX + url.substring(endIndex + 1);
            UrlBuilder urlBuilder = UrlBuilder.parse((String)httpsUrl);
            HashMap<String, String> properties = new HashMap<String, String>(urlBuilder.getQuery());
            urlBuilder.setQuery(null);
            String databaseName = urlBuilder.getPath().replace("/", "");
            urlBuilder.setPath(null);
            properties.put(ACCOUNT_ENDPOINT_PROPERTY, urlBuilder.toString());
            properties.put(ACCOUNT_KEY_PROPERTY, accountKey);
            properties.put(DATABASE_NAME_PROPERTY, databaseName);
            return new CosmosConnectionString(url, properties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse connection Url String: ", e);
        }
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public Optional<String> getAccountEndpoint() {
        return this.getProperty(ACCOUNT_ENDPOINT_PROPERTY);
    }

    public Optional<String> getAccountKey() {
        return this.getProperty(ACCOUNT_KEY_PROPERTY);
    }

    public Optional<String> getDatabaseName() {
        return this.getProperty(DATABASE_NAME_PROPERTY);
    }

    private CosmosConnectionString(String connectionString, Map<String, String> properties) {
        this.connectionString = connectionString;
        this.properties = properties;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

