/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.database;

import com.azure.cosmos.CosmosDatabase;
import java.util.Arrays;
import java.util.Optional;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.cosmosdb.database.CosmosClientDriver;
import liquibase.ext.cosmosdb.database.CosmosConnection;
import liquibase.ext.cosmosdb.statement.DeleteAllContainersStatement;
import liquibase.nosql.database.AbstractNoSqlDatabase;
import liquibase.statement.SqlStatement;

public class CosmosLiquibaseDatabase
extends AbstractNoSqlDatabase {
    public static final String COSMOSDB_PRODUCT_NAME = "Cosmos DB";
    public static final String COSMOSDB_PRODUCT_SHORT_NAME = "cosmosdb";
    public static final int DEFAULT_PORT = 8081;

    @Override
    public void dropDatabaseObjects(CatalogAndSchema schemaToDrop) throws LiquibaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this);
        DeleteAllContainersStatement deleteAllContainersStatement = new DeleteAllContainersStatement(Arrays.asList(this.getDatabaseChangeLogTableName(), this.getDatabaseChangeLogLockTableName()));
        executor.execute((SqlStatement)deleteAllContainersStatement);
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService((Database)this).destroy();
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("cosmosdb://")) {
            return CosmosClientDriver.class.getName();
        }
        return null;
    }

    public CosmosDatabase getCosmosDatabase() {
        return ((CosmosConnection)this.getConnection()).getCosmosDatabase();
    }

    @Override
    public String getDatabaseProductName() {
        return COSMOSDB_PRODUCT_NAME;
    }

    public String getShortName() {
        return COSMOSDB_PRODUCT_SHORT_NAME;
    }

    public Integer getDefaultPort() {
        return 8081;
    }

    protected String getDefaultDatabaseProductName() {
        return COSMOSDB_PRODUCT_NAME;
    }

    @Override
    public String toString() {
        return this.getDatabaseProductName() + " : " + Optional.ofNullable(this.getConnection()).map(DatabaseConnection::getURL).orElse("NOT CONNECTED");
    }
}

