/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.lockservice;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.lockservice.CosmosChangeLogLock;
import liquibase.ext.cosmosdb.lockservice.CreateChangeLogLockContainerStatement;
import liquibase.ext.cosmosdb.lockservice.ReplaceLockChangeLogStatement;
import liquibase.ext.cosmosdb.lockservice.SelectChangeLogLockStatement;
import liquibase.ext.cosmosdb.lockservice.SelectChangeLogLocksStatement;
import liquibase.ext.cosmosdb.statement.CountContainersByNameStatement;
import liquibase.ext.cosmosdb.statement.DeleteContainerStatement;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.logging.Logger;
import liquibase.nosql.lockservice.AbstractNoSqlLockService;
import liquibase.statement.SqlStatement;

public class CosmosLockService
extends AbstractNoSqlLockService<CosmosLiquibaseDatabase> {
    private final Logger log = Scope.getCurrentScope().getLog(this.getClass());

    public boolean supports(Database database) {
        return "Cosmos DB".equals(database.getDatabaseProductName());
    }

    @Override
    protected Boolean isLocked() throws DatabaseException {
        Optional<CosmosChangeLogLock> lock = Optional.ofNullable(this.getExecutor().queryForObject((SqlStatement)new SelectChangeLogLockStatement(this.getDatabaseChangeLogLockTableName()), CosmosChangeLogLock.class));
        return lock.map(CosmosChangeLogLock::getLocked).orElse(Boolean.FALSE);
    }

    @Override
    protected int replaceLock(boolean locked) throws DatabaseException {
        return this.getExecutor().update((SqlStatement)new ReplaceLockChangeLogStatement(this.getDatabaseChangeLogLockTableName(), locked));
    }

    @Override
    protected List<DatabaseChangeLogLock> queryLocks() throws DatabaseException {
        List<Object> rows = this.getExecutor().queryForList((SqlStatement)new SelectChangeLogLocksStatement(this.getDatabaseChangeLogLockTableName()), CosmosChangeLogLock.class);
        return rows.stream().map(DatabaseChangeLogLock.class::cast).collect(Collectors.toList());
    }

    @Override
    protected Boolean existsRepository() throws DatabaseException {
        return this.getExecutor().queryForLong((SqlStatement)new CountContainersByNameStatement(((CosmosLiquibaseDatabase)((Object)this.getDatabase())).getDatabaseChangeLogLockTableName())) == 1L;
    }

    @Override
    protected void createRepository() throws DatabaseException {
        CreateChangeLogLockContainerStatement createChangeLogLockContainerStatement = new CreateChangeLogLockContainerStatement(this.getDatabaseChangeLogLockTableName());
        this.getExecutor().execute((SqlStatement)createChangeLogLockContainerStatement);
    }

    @Override
    protected void adjustRepository() throws DatabaseException {
    }

    @Override
    protected void dropRepository() throws DatabaseException {
        this.getExecutor().execute((SqlStatement)new DeleteContainerStatement(this.getDatabaseChangeLogLockTableName()));
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }
}

