/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.lockservice;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.lockservice.ChangeLogLockRepository;
import liquibase.ext.cosmosdb.lockservice.CosmosChangeLogLock;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.nosql.statement.NoSqlQueryForListStatement;

public class SelectChangeLogLocksStatement
extends AbstractCosmosContainerStatement
implements NoSqlQueryForListStatement<CosmosLiquibaseDatabase, CosmosChangeLogLock> {
    public static final String COMMAND_NAME = "selectLocks";

    public SelectChangeLogLocksStatement(String containerName) {
        super(containerName);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public List<CosmosChangeLogLock> readAll(CosmosLiquibaseDatabase database) {
        ChangeLogLockRepository repository = new ChangeLogLockRepository(database.getCosmosDatabase(), this.getContainerName());
        return repository.getAll().stream().filter(CosmosChangeLogLock::getLocked).collect(Collectors.toList());
    }

    @Override
    public List<CosmosChangeLogLock> queryForList(CosmosLiquibaseDatabase database) {
        return this.readAll(database);
    }
}

