/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.persistence;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import liquibase.util.StringUtil;

public abstract class AbstractItemToDocumentConverter<A, B> {
    public static final String ISO_8601_UTC_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public abstract B toDocument(A var1);

    public abstract A fromDocument(B var1);

    public Date toDate(String dateString) {
        try {
            if (Objects.isNull(StringUtil.trimToNull((String)dateString))) {
                return null;
            }
            return dateFormatter.parse(dateString);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse to Date: [" + dateString + "] with pattern: " + ISO_8601_UTC_DATETIME_FORMAT, e);
        }
    }

    public String fromDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return dateFormatter.format(date);
    }
}

