/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import java.util.Map;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlQueryForLongStatement;

public class CountDocumentsInContainerStatement
extends AbstractCosmosContainerStatement
implements NoSqlQueryForLongStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "countDocumentsInContainer";

    public CountDocumentsInContainerStatement(String containerName) {
        super(containerName);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public long queryForLong(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.getContainerName());
        return cosmosContainer.readAllItems(JsonUtils.DEFAULT_PARTITION_KEY, Map.class).stream().count();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountDocumentsInContainerStatement)) {
            return false;
        }
        CountDocumentsInContainerStatement other = (CountDocumentsInContainerStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountDocumentsInContainerStatement;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

