/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.Optional;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class CreateContainerStatement
extends AbstractCosmosStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "createContainer";
    private final String containerName;
    private final String containerProperties;
    private final String throughputProperties;
    private final Boolean skipExisting;

    public CreateContainerStatement(String containerName, String containerProperties, String throughputProperties) {
        this(containerName, containerProperties, throughputProperties, Boolean.FALSE);
    }

    public CreateContainerStatement(String containerName, String containerProperties) {
        this(containerName, containerProperties, null);
    }

    public CreateContainerStatement(String containerName) {
        this(containerName, null);
    }

    public CreateContainerStatement() {
        this(null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + this.getContainerName() + ", " + this.getContainerProperties() + ", " + this.getThroughputProperties() + ", " + this.getSkipExisting() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainerProperties cosmosContainerProperties = JsonUtils.toContainerProperties(this.getContainerName(), this.getContainerProperties());
        ThroughputProperties cosmosThroughputProperties = JsonUtils.toThroughputProperties(this.getThroughputProperties());
        if (Optional.ofNullable(this.skipExisting).orElse(Boolean.FALSE).booleanValue()) {
            database.getCosmosDatabase().createContainerIfNotExists(cosmosContainerProperties, cosmosThroughputProperties);
        } else {
            database.getCosmosDatabase().createContainer(cosmosContainerProperties, cosmosThroughputProperties);
        }
    }

    public CreateContainerStatement(String containerName, String containerProperties, String throughputProperties, Boolean skipExisting) {
        this.containerName = containerName;
        this.containerProperties = containerProperties;
        this.throughputProperties = throughputProperties;
        this.skipExisting = skipExisting;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerProperties() {
        return this.containerProperties;
    }

    public String getThroughputProperties() {
        return this.throughputProperties;
    }

    public Boolean getSkipExisting() {
        return this.skipExisting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateContainerStatement)) {
            return false;
        }
        CreateContainerStatement other = (CreateContainerStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$skipExisting = this.getSkipExisting();
        Boolean other$skipExisting = other.getSkipExisting();
        if (this$skipExisting == null ? other$skipExisting != null : !((Object)this$skipExisting).equals(other$skipExisting)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        String this$containerProperties = this.getContainerProperties();
        String other$containerProperties = other.getContainerProperties();
        if (this$containerProperties == null ? other$containerProperties != null : !this$containerProperties.equals(other$containerProperties)) {
            return false;
        }
        String this$throughputProperties = this.getThroughputProperties();
        String other$throughputProperties = other.getThroughputProperties();
        return !(this$throughputProperties == null ? other$throughputProperties != null : !this$throughputProperties.equals(other$throughputProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateContainerStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $skipExisting = this.getSkipExisting();
        result = result * 59 + ($skipExisting == null ? 43 : ((Object)$skipExisting).hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        String $containerProperties = this.getContainerProperties();
        result = result * 59 + ($containerProperties == null ? 43 : $containerProperties.hashCode());
        String $throughputProperties = this.getThroughputProperties();
        result = result * 59 + ($throughputProperties == null ? 43 : $throughputProperties.hashCode());
        return result;
    }
}

