/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import java.util.Optional;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class CreateStoredProcedureStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "createStoredProcedure";
    private final CosmosStoredProcedureProperties procedureProperties;
    private final Boolean replaceExisting;

    public CreateStoredProcedureStatement() {
        this(null, (String)null, null);
    }

    public CreateStoredProcedureStatement(String containerName, String procedurePropertiesJson, Boolean replaceExisting) {
        this(containerName, JsonUtils.orEmptyStoredProcedureProperties(procedurePropertiesJson), replaceExisting);
    }

    public CreateStoredProcedureStatement(String containerName, CosmosStoredProcedureProperties procedureProperties, Boolean replaceExisting) {
        super(containerName);
        this.procedureProperties = procedureProperties;
        this.replaceExisting = Optional.ofNullable(replaceExisting).orElse(Boolean.FALSE);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getContainerName() + "." + this.getCommandName() + "(" + this.procedureProperties.toString() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosScripts cosmosScripts = database.getCosmosDatabase().getContainer(this.getContainerName()).getScripts();
        if (this.replaceExisting.booleanValue()) {
            cosmosScripts.getStoredProcedure(this.procedureProperties.getId()).replace(this.procedureProperties);
        } else {
            cosmosScripts.createStoredProcedure(this.procedureProperties);
        }
    }

    public CosmosStoredProcedureProperties getProcedureProperties() {
        return this.procedureProperties;
    }

    public Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateStoredProcedureStatement)) {
            return false;
        }
        CreateStoredProcedureStatement other = (CreateStoredProcedureStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$replaceExisting = this.getReplaceExisting();
        Boolean other$replaceExisting = other.getReplaceExisting();
        if (this$replaceExisting == null ? other$replaceExisting != null : !((Object)this$replaceExisting).equals(other$replaceExisting)) {
            return false;
        }
        CosmosStoredProcedureProperties this$procedureProperties = this.getProcedureProperties();
        CosmosStoredProcedureProperties other$procedureProperties = other.getProcedureProperties();
        return !(this$procedureProperties == null ? other$procedureProperties != null : !this$procedureProperties.equals(other$procedureProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateStoredProcedureStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $replaceExisting = this.getReplaceExisting();
        result = result * 59 + ($replaceExisting == null ? 43 : ((Object)$replaceExisting).hashCode());
        CosmosStoredProcedureProperties $procedureProperties = this.getProcedureProperties();
        result = result * 59 + ($procedureProperties == null ? 43 : $procedureProperties.hashCode());
        return result;
    }
}

