/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.Map;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class DeleteEachItemStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "deleteEachItem";
    private final SqlQuerySpec query;

    public DeleteEachItemStatement(String containerName, String jsonQuery) {
        super(containerName);
        this.query = JsonUtils.orEmptySqlQuerySpec(jsonQuery);
    }

    public DeleteEachItemStatement(String containerName, SqlQuerySpec query) {
        super(containerName);
        this.query = query;
    }

    public DeleteEachItemStatement() {
        this(null, (String)null);
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerName);
        cosmosContainer.queryItems(this.query, null, Map.class).stream().forEach(d -> cosmosContainer.deleteItem((String)d.get("id"), JsonUtils.DEFAULT_PARTITION_KEY_PERSIST, null));
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }
}

