/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import liquibase.util.StringUtil;

public final class JsonUtils {
    public static final ObjectMapper OBJECT_MAPPER = Utils.getSimpleObjectMapper();
    public static final String DEFAULT_PARTITION_KEY_NAME = "null";
    public static final String DEFAULT_PARTITION_KEY_PATH = "/null";
    public static final PartitionKey DEFAULT_PARTITION_KEY = new PartitionKey((Object)"default");
    public static final PartitionKey DEFAULT_PARTITION_KEY_PERSIST = PartitionKey.NONE;
    public static final String COSMOS_ID_FIELD = "id";
    public static final String COSMOS_ID_PARAMETER = "@id";
    public static final String QUERY_SELECT_ALL = "SELECT * FROM c";

    public static Document orEmptyDocument(String json) {
        return Optional.ofNullable(StringUtil.trimToNull((String)json)).map(Document::new).orElseGet(Document::new);
    }

    public static SqlQuerySpec orEmptySqlQuerySpec(String json) {
        return Optional.ofNullable(StringUtil.trimToNull((String)json)).map(JsonSerializable::new).map(js -> {
            SqlQuerySpec querySpec = new SqlQuerySpec();
            querySpec.setQueryText(js.getString("query"));
            querySpec.setParameters(js.getList("parameters", SqlParameter.class, new boolean[0]));
            return querySpec;
        }).orElseGet(SqlQuerySpec::new);
    }

    public static CosmosStoredProcedureProperties orEmptyStoredProcedureProperties(String json) {
        return Optional.ofNullable(StringUtil.trimToNull((String)json)).map(JsonSerializable::new).map(js -> new CosmosStoredProcedureProperties(js.getString(COSMOS_ID_FIELD), js.getString("body"))).orElse(new CosmosStoredProcedureProperties(null, null));
    }

    public static Document fromMap(Map<?, ?> source) {
        return Document.fromObject(source, (ObjectMapper)OBJECT_MAPPER);
    }

    public static Document mergeDocuments(Document destination, Document source) {
        destination.getPropertyBag().setAll(source.getPropertyBag().deepCopy());
        return destination;
    }

    public static CosmosContainerProperties toContainerProperties(String containerName, String containerPropertiesJson) {
        CosmosContainerProperties cosmosContainerProperties = new CosmosContainerProperties(containerName, DEFAULT_PARTITION_KEY_PATH);
        if (StringUtil.isNotEmpty((String)StringUtil.trimToNull((String)containerPropertiesJson))) {
            DocumentCollection documentCollection = new DocumentCollection(containerPropertiesJson);
            if (Objects.nonNull(documentCollection.getPartitionKey())) {
                cosmosContainerProperties.setPartitionKeyDefinition(documentCollection.getPartitionKey());
            }
            if (Objects.nonNull(documentCollection.getIndexingPolicy())) {
                cosmosContainerProperties.setIndexingPolicy(documentCollection.getIndexingPolicy());
            }
            if (Objects.nonNull(documentCollection.getUniqueKeyPolicy())) {
                cosmosContainerProperties.setUniqueKeyPolicy(documentCollection.getUniqueKeyPolicy());
            }
            if (Objects.nonNull(documentCollection.getAnalyticalStoreTimeToLiveInSeconds())) {
                cosmosContainerProperties.setAnalyticalStoreTimeToLiveInSeconds(documentCollection.getAnalyticalStoreTimeToLiveInSeconds());
            }
            if (Objects.nonNull(documentCollection.getDefaultTimeToLive())) {
                cosmosContainerProperties.setDefaultTimeToLiveInSeconds(documentCollection.getDefaultTimeToLive());
            }
            if (Objects.nonNull(documentCollection.getConflictResolutionPolicy())) {
                cosmosContainerProperties.setConflictResolutionPolicy(documentCollection.getConflictResolutionPolicy());
            }
        }
        return cosmosContainerProperties;
    }

    public static ThroughputProperties toThroughputProperties(String throughputPropertiesJson) {
        if (Objects.nonNull(StringUtil.trimToNull((String)throughputPropertiesJson))) {
            JsonNode node;
            try {
                node = OBJECT_MAPPER.readTree(throughputPropertiesJson);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(String.format("Unable to parse JSON %s", throughputPropertiesJson), e);
            }
            if (node.isValueNode()) {
                return ThroughputProperties.createManualThroughput((int)((ValueNode)node).asInt());
            }
            if (node.isContainerNode() && ((ContainerNode)node).has("maxThroughput")) {
                return ThroughputProperties.createAutoscaledThroughput((int)((ValueNode)node.get("maxThroughput")).asInt());
            }
        }
        return null;
    }

    private JsonUtils() {
    }
}

