/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CreateItemStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;

public class UpdateEachItemStatement
extends CreateItemStatement {
    public static final String COMMAND_NAME = "updateEachItem";
    private final SqlQuerySpec query;

    public UpdateEachItemStatement(String containerName, String jsonQuery, String jsonDocument) {
        super(containerName, jsonDocument);
        this.query = JsonUtils.orEmptySqlQuerySpec(jsonQuery);
    }

    public UpdateEachItemStatement(String containerName, SqlQuerySpec query, Document document) {
        super(containerName, document);
        this.query = query;
    }

    public UpdateEachItemStatement() {
        this(null, (SqlQuerySpec)null, null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerName);
        Document source = this.getDocument();
        List<Document> documents = cosmosContainer.queryItems(this.query, null, Map.class).stream().map(JsonUtils::fromMap).map(Document.class::cast).map(d -> JsonUtils.mergeDocuments(d, source)).collect(Collectors.toList());
        documents.forEach(destination -> {
            JsonUtils.mergeDocuments(source, destination);
            cosmosContainer.upsertItem(destination);
        });
    }
}

