/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CreateItemStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;

public class UpsertItemStatement
extends CreateItemStatement {
    public static final String COMMAND_NAME = "upsertItem";

    public UpsertItemStatement(String containerName, String jsonDocument) {
        this(containerName, JsonUtils.orEmptyDocument(jsonDocument));
    }

    public UpsertItemStatement(String containerName, Document document) {
        super(containerName, document);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.getContainerName());
        cosmosContainer.upsertItem((Object)this.getDocument());
    }

    @Override
    public String toString() {
        return this.toJs();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpsertItemStatement)) {
            return false;
        }
        UpsertItemStatement other = (UpsertItemStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpsertItemStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

