/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.CreateItemStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createItem", description="Insert a Single Document https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmoscontainer.createitem?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/create-a-document", priority=1, appliesTo={"container"})
public class CreateItemChange
extends AbstractCosmosChange {
    private String containerId;
    private String document;

    public String getConfirmationMessage() {
        return "Item inserted to container: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateItemStatement createItemStatement = new CreateItemStatement(this.containerId, this.document);
        return new SqlStatement[]{createItemStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getDocument() {
        return this.document;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setDocument(String document) {
        this.document = document;
    }
}

