/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.DeleteContainerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="deleteContainer", description="Delete container https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmoscontainer.delete?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/delete-a-collection", priority=1, appliesTo={"container"})
public class DeleteContainerChange
extends AbstractCosmosChange {
    private String containerId;
    private Boolean skipMissing;

    public String getConfirmationMessage() {
        return "Container deleted: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        DeleteContainerStatement deleteContainerStatement = new DeleteContainerStatement(this.containerId, this.skipMissing);
        return new SqlStatement[]{deleteContainerStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Boolean getSkipMissing() {
        return this.skipMissing;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setSkipMissing(Boolean skipMissing) {
        this.skipMissing = skipMissing;
    }
}

