/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.DeleteStoredProcedureStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="deleteStoredProcedure", description="Delete Stored Procedure https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmosstoredprocedure.delete?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/delete-a-stored-procedure", priority=1, appliesTo={"storedProcedure"})
public class DeleteStoredProcedureChange
extends AbstractCosmosChange {
    private String containerId;
    private String procedureProperties;
    private Boolean skipMissing;

    public String getConfirmationMessage() {
        return "Stored Procedure deleted for: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        DeleteStoredProcedureStatement deleteStoredProcedureStatement = new DeleteStoredProcedureStatement(this.containerId, this.procedureProperties, this.skipMissing);
        return new SqlStatement[]{deleteStoredProcedureStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getProcedureProperties() {
        return this.procedureProperties;
    }

    public Boolean getSkipMissing() {
        return this.skipMissing;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setProcedureProperties(String procedureProperties) {
        this.procedureProperties = procedureProperties;
    }

    public void setSkipMissing(Boolean skipMissing) {
        this.skipMissing = skipMissing;
    }
}

