/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.ReplaceContainerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="replaceContainer", description="Replace container https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmoscontainer.replace?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/replace-a-collection", priority=1, appliesTo={"container"})
public class ReplaceContainerChange
extends AbstractCosmosChange {
    private String containerId;
    private String containerProperties;
    private String throughputProperties;

    public String getConfirmationMessage() {
        return "Container replaced: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        ReplaceContainerStatement createContainerStatement = new ReplaceContainerStatement(this.containerId, this.containerProperties, this.throughputProperties);
        return new SqlStatement[]{createContainerStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerProperties() {
        return this.containerProperties;
    }

    public String getThroughputProperties() {
        return this.throughputProperties;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setContainerProperties(String containerProperties) {
        this.containerProperties = containerProperties;
    }

    public void setThroughputProperties(String throughputProperties) {
        this.throughputProperties = throughputProperties;
    }
}

