/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.UpdateEachItemStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="updateEachItem", description="Updates in a loop each Document in a Query https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmoscontainer.upsertitem?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/replace-a-document\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/query-documents", priority=1, appliesTo={"container"})
public class UpdateEachItemChange
extends AbstractCosmosChange {
    private String containerId;
    private String query;
    private String document;

    public String getConfirmationMessage() {
        return "Items updated in container: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        UpdateEachItemStatement updateEachItemStatement = new UpdateEachItemStatement(this.containerId, this.query, this.document);
        return new SqlStatement[]{updateEachItemStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDocument() {
        return this.document;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setDocument(String document) {
        this.document = document;
    }
}

