/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.changelog;

import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.cosmosdb.changelog.CreateChangeLogContainerStatement;
import liquibase.ext.cosmosdb.changelog.GetNextChangeSetSequenceValueStatement;
import liquibase.ext.cosmosdb.changelog.MarkChangeSetRanStatement;
import liquibase.ext.cosmosdb.changelog.SelectChangeLogRanChangeSetsStatement;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CountContainersByNameStatement;
import liquibase.ext.cosmosdb.statement.CountDocumentsInContainerStatement;
import liquibase.ext.cosmosdb.statement.DeleteContainerStatement;
import liquibase.ext.cosmosdb.statement.DeleteEachItemStatement;
import liquibase.ext.cosmosdb.statement.UpdateEachItemStatement;
import liquibase.logging.Logger;
import liquibase.nosql.changelog.AbstractNoSqlHistoryService;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

public class CosmosHistoryService
extends AbstractNoSqlHistoryService<CosmosLiquibaseDatabase> {
    private final Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    public boolean supports(Database database) {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " supports()");
        return "Cosmos DB".equals(database.getDatabaseProductName());
    }

    @Override
    protected Boolean existsRepository() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " existsRepository()");
        return this.getExecutor().queryForLong((SqlStatement)new CountContainersByNameStatement(this.getDatabaseChangeLogTableName())) == 1L;
    }

    @Override
    protected void createRepository() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " createRepository()");
        CreateChangeLogContainerStatement createChangeLogContainerStatement = new CreateChangeLogContainerStatement(this.getDatabaseChangeLogTableName());
        this.getExecutor().execute((SqlStatement)createChangeLogContainerStatement);
    }

    @Override
    protected void adjustRepository() throws DatabaseException {
    }

    @Override
    protected void dropRepository() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " dropRepository()");
        this.getExecutor().execute((SqlStatement)new DeleteContainerStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected List<RanChangeSet> queryRanChangeSets() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " queryRanChangeSets()");
        return this.getExecutor().queryForList((SqlStatement)new SelectChangeLogRanChangeSetsStatement(this.getDatabaseChangeLogTableName()), RanChangeSet.class).stream().map(RanChangeSet.class::cast).collect(Collectors.toList());
    }

    @Override
    protected Integer generateNextSequence() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " generateNextSequence()");
        return (int)this.getExecutor().queryForLong((SqlStatement)new GetNextChangeSetSequenceValueStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected void markChangeSetRun(ChangeSet changeSet, ChangeSet.ExecType execType, Integer nextSequenceValue) throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " markChangeSetRun(cs,et,nxtseq)");
        NoSqlExecutor executor = this.getExecutor();
        MarkChangeSetRanStatement markChangeSetRanStatement = new MarkChangeSetRanStatement(this.getDatabaseChangeLogTableName(), changeSet, execType, nextSequenceValue, this.getDeploymentId());
        executor.execute((SqlStatement)markChangeSetRanStatement);
    }

    public String extractTag(ChangeSet changeSet) {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " extractTag(changeSet)");
        String tag = null;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof TagDatabaseChange)) continue;
            TagDatabaseChange tagChange = (TagDatabaseChange)change;
            tag = StringUtil.trimToNull((String)tagChange.getTag());
        }
        return tag;
    }

    @Override
    protected void removeRanChangeSet(ChangeSet changeSet) throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " removeRanChangeSet(changeSet)");
        String query = "SELECT * FROM c where c.author=\"" + changeSet.getAuthor() + "\" and c.changeSetId=\"" + changeSet.getId() + "\" and c.fileName=\"" + changeSet.getFilePath() + "\"";
        SqlQuerySpec querySpec = new SqlQuerySpec(query);
        this.getExecutor().execute((SqlStatement)new DeleteEachItemStatement(this.getDatabaseChangeLogTableName(), querySpec));
    }

    @Override
    protected void clearCheckSums() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " clearCheckSums()");
        String query = "SELECT * FROM c";
        String docString = "{\n\"md5sum\" : null\n}";
        Document doc = new Document(docString);
        SqlQuerySpec querySpec = new SqlQuerySpec(query);
        this.getExecutor().execute((SqlStatement)new UpdateEachItemStatement(this.getDatabaseChangeLogTableName(), querySpec, doc));
    }

    @Override
    protected long countTags(String tag) throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " countTags(tag)");
        return 0L;
    }

    @Override
    protected void tagLast(String tagString) throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " tagLast(tag)");
        String query = "SELECT TOP 1 * FROM c order by c.dateExecuted DESC";
        SqlQuerySpec querySpec = new SqlQuerySpec(query);
        String docString = "{\n\"tag\" : \"" + tagString + "\"\n}";
        Document doc = new Document(docString);
        this.getExecutor().execute((SqlStatement)new UpdateEachItemStatement(this.getDatabaseChangeLogTableName(), querySpec, doc));
    }

    @Override
    protected long countRanChangeSets() throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " countRanChangeSets()");
        return this.getExecutor().queryForLong((SqlStatement)new CountDocumentsInContainerStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected void updateCheckSum(ChangeSet changeSet) throws DatabaseException {
        this.getLogger().fine("Entering: " + ((Object)((Object)this)).getClass().getSimpleName() + " updateCheckSum(changeSet)");
        String query = "SELECT * FROM c where c.author=\"" + changeSet.getAuthor() + "\" and c.changeSetId=\"" + changeSet.getId() + "\" and c.fileName=\"" + changeSet.getFilePath() + "\"";
        SqlQuerySpec querySpec = new SqlQuerySpec(query);
        String docString = "{\n\"md5sum\" : \"" + changeSet.generateCheckSum() + "\"\n}";
        Document doc = new Document(docString);
        this.getExecutor().execute((SqlStatement)new UpdateEachItemStatement(this.getDatabaseChangeLogTableName(), querySpec, doc));
    }
}

