/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.database;

import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.util.CosmosPagedIterable;
import java.io.Closeable;

public class CosmosClientProxy
implements Closeable {
    private final CosmosClient cosmosClient;

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id, ThroughputProperties throughputProperties) {
        return this.cosmosClient.createDatabaseIfNotExists(id, throughputProperties);
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id) {
        return this.cosmosClient.createDatabaseIfNotExists(id);
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) {
        return this.cosmosClient.createDatabase(databaseProperties, options);
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties) {
        return this.cosmosClient.createDatabase(databaseProperties);
    }

    public CosmosDatabaseResponse createDatabase(String id) {
        return this.cosmosClient.createDatabase(id);
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties, CosmosDatabaseRequestOptions options) {
        return this.cosmosClient.createDatabase(databaseProperties, throughputProperties, options);
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties) {
        return this.cosmosClient.createDatabase(databaseProperties, throughputProperties);
    }

    public CosmosDatabaseResponse createDatabase(String id, ThroughputProperties throughputProperties) {
        return this.cosmosClient.createDatabase(id, throughputProperties);
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> readAllDatabases() {
        return this.cosmosClient.readAllDatabases();
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions options) {
        return this.cosmosClient.queryDatabases(query, options);
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.cosmosClient.queryDatabases(querySpec, options);
    }

    public CosmosDatabase getDatabase(String id) {
        return this.cosmosClient.getDatabase(id);
    }

    @Override
    public void close() {
        this.cosmosClient.close();
    }

    public static CosmosClientProxyBuilder builder() {
        return new CosmosClientProxyBuilder();
    }

    public CosmosClientProxy(CosmosClient cosmosClient) {
        this.cosmosClient = cosmosClient;
    }

    public CosmosClient getCosmosClient() {
        return this.cosmosClient;
    }

    public static class CosmosClientProxyBuilder {
        private CosmosClient cosmosClient;

        CosmosClientProxyBuilder() {
        }

        public CosmosClientProxyBuilder cosmosClient(CosmosClient cosmosClient) {
            this.cosmosClient = cosmosClient;
            return this;
        }

        public CosmosClientProxy build() {
            return new CosmosClientProxy(this.cosmosClient);
        }

        public String toString() {
            return "CosmosClientProxy.CosmosClientProxyBuilder(cosmosClient=" + this.cosmosClient + ")";
        }
    }
}

