/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.database;

import com.azure.cosmos.CosmosDatabase;
import java.sql.Driver;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import liquibase.exception.DatabaseException;
import liquibase.ext.cosmosdb.database.CosmosClientDriver;
import liquibase.ext.cosmosdb.database.CosmosClientProxy;
import liquibase.ext.cosmosdb.database.CosmosConnectionString;
import liquibase.nosql.database.AbstractNoSqlConnection;
import liquibase.util.StringUtil;

public class CosmosConnection
extends AbstractNoSqlConnection {
    public static final String LIQUIBASE_EXTENSION_USER_AGENT_SUFFIX = "LiquibaseExtension";
    private CosmosConnectionString cosmosConnectionString;
    private CosmosClientProxy cosmosClient;
    private CosmosDatabase cosmosDatabase;

    public String getCatalog() throws DatabaseException {
        return this.cosmosConnectionString.getDatabaseName().orElse("");
    }

    public String getDatabaseProductName() throws DatabaseException {
        return "Cosmos DB";
    }

    @Override
    public String getDatabaseProductVersion() throws DatabaseException {
        return "3.12.7";
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        return 3;
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        return 12;
    }

    public String getURL() {
        return Optional.ofNullable(this.cosmosConnectionString).map(CosmosConnectionString::toUrl).orElse("");
    }

    public String getConnectionUserName() {
        return Optional.ofNullable(this.cosmosConnectionString).flatMap(CosmosConnectionString::getAccountEndpoint).orElse("");
    }

    public boolean isClosed() throws DatabaseException {
        return Objects.isNull(this.cosmosClient) || Objects.isNull(this.cosmosDatabase);
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        this.open(CosmosConnectionString.fromConnectionString(url), driverObject, driverProperties);
    }

    public void open(CosmosConnectionString cosmosConnectionString, Driver driverObject, Properties driverProperties) throws DatabaseException {
        this.cosmosConnectionString = cosmosConnectionString;
        if (!(cosmosConnectionString.getAccountEndpoint().isPresent() && cosmosConnectionString.getAccountKey().isPresent() && cosmosConnectionString.getDatabaseName().isPresent())) {
            throw new IllegalArgumentException(String.format("Missing one of the properties [%s, %s, %s]", "accountEndpoint", "accountKey", "databaseName"));
        }
        this.cosmosClient = ((CosmosClientDriver)driverObject).connect(cosmosConnectionString);
        String databaseName = cosmosConnectionString.getDatabaseName().get();
        try {
            this.cosmosClient.createDatabaseIfNotExists(databaseName);
            this.cosmosDatabase = this.cosmosClient.getDatabase(databaseName);
        }
        catch (Exception e) {
            throw new DatabaseException("Could not create database: " + databaseName, (Throwable)e);
        }
    }

    public boolean supports(String url) {
        return !StringUtil.isEmpty((String)StringUtil.trimToNull((String)url)) && url.startsWith("cosmosdb://");
    }

    public void close() throws DatabaseException {
        try {
            if (!this.isClosed()) {
                this.cosmosClient.close();
                this.reset();
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private void reset() {
        this.cosmosClient = null;
        this.cosmosDatabase = null;
        this.cosmosConnectionString = null;
    }

    public CosmosConnectionString getCosmosConnectionString() {
        return this.cosmosConnectionString;
    }

    public CosmosClientProxy getCosmosClient() {
        return this.cosmosClient;
    }

    public CosmosDatabase getCosmosDatabase() {
        return this.cosmosDatabase;
    }

    public void setCosmosConnectionString(CosmosConnectionString cosmosConnectionString) {
        this.cosmosConnectionString = cosmosConnectionString;
    }

    public void setCosmosClient(CosmosClientProxy cosmosClient) {
        this.cosmosClient = cosmosClient;
    }

    public void setCosmosDatabase(CosmosDatabase cosmosDatabase) {
        this.cosmosDatabase = cosmosDatabase;
    }
}

