/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.lockservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import liquibase.ext.cosmosdb.lockservice.CosmosChangeLogLock;
import liquibase.ext.cosmosdb.persistence.AbstractItemToDocumentConverter;

public class ChangeLogLockToDocumentConverter
extends AbstractItemToDocumentConverter<CosmosChangeLogLock, Map<String, Object>> {
    @Override
    public Map<String, Object> toDocument(CosmosChangeLogLock item) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put("id", Integer.toString(item.getId()));
        document.put("lockGranted", this.fromDate(item.getLockGranted()));
        document.put("lockedBy", item.getLockedBy());
        document.put("locked", item.getLocked());
        return document;
    }

    @Override
    public CosmosChangeLogLock fromDocument(Map<String, Object> document) {
        return CosmosChangeLogLock.builder().id(Optional.ofNullable(document.get("id")).map(s -> Integer.parseInt((String)s)).orElse(-1)).lockGranted(Optional.ofNullable(document.get("lockGranted")).map(s -> this.toDate((String)s)).orElse(null)).lockedBy(Optional.ofNullable((String)document.get("lockedBy")).orElse("")).locked(Optional.ofNullable(document.get("locked")).orElse(null)).build();
    }
}

