/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.lockservice;

import java.util.Date;
import java.util.Optional;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.lockservice.ChangeLogLockRepository;
import liquibase.ext.cosmosdb.lockservice.CosmosChangeLogLock;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import liquibase.util.NetUtil;

public class ReplaceLockChangeLogStatement
extends AbstractCosmosContainerStatement
implements NoSqlUpdateStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "replaceLock";
    protected static final String HOST_NAME;
    protected static final String HOST_ADDRESS;
    public static final String LIQUIBASE_HOST_DESCRIPTION = "liquibase.hostDescription";
    protected static final String HOST_DESCRIPTION;
    private final boolean locked;

    public ReplaceLockChangeLogStatement(String containerId, boolean locked) {
        super(containerId);
        this.locked = locked;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + this.containerId + ", " + this.locked + ");";
    }

    protected int replace(CosmosLiquibaseDatabase database) {
        ChangeLogLockRepository repository = new ChangeLogLockRepository(database.getCosmosDatabase(), this.getContainerId());
        CosmosChangeLogLock lockEntry = new CosmosChangeLogLock(ITEM_ID_1, new Date(), HOST_NAME + HOST_DESCRIPTION + " (" + HOST_ADDRESS + ")", this.locked);
        return repository.upsert(lockEntry);
    }

    @Override
    public int update(CosmosLiquibaseDatabase database) {
        return this.replace(database);
    }

    public boolean isLocked() {
        return this.locked;
    }

    static {
        HOST_DESCRIPTION = Optional.ofNullable(System.getProperty(LIQUIBASE_HOST_DESCRIPTION)).map("#"::concat).orElse("");
        try {
            HOST_NAME = NetUtil.getLocalHostName();
            HOST_ADDRESS = NetUtil.getLocalHostAddress();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }
}

