/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.persistence;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.ext.cosmosdb.persistence.AbstractItemToDocumentConverter;

public abstract class AbstractRepository<T> {
    private final CosmosContainer container;
    private final AbstractItemToDocumentConverter<T, Map<String, Object>> converter;

    public AbstractRepository(CosmosContainer container, AbstractItemToDocumentConverter<T, Map<String, Object>> converter) {
        this.container = container;
        this.converter = converter;
    }

    public Optional<T> get(String id) {
        SqlQuerySpec querySpec = new SqlQuerySpec("SELECT * FROM c WHERE c.id=@id", new SqlParameter[]{new SqlParameter("@id", (Object)id)});
        return this.container.queryItems(querySpec, null, Map.class).stream().findFirst().map(map -> this.converter.fromDocument((Map<String, Object>)map));
    }

    public List<T> getAll() {
        return this.readAllItems().stream().map(this.converter::fromDocument).collect(Collectors.toList());
    }

    public List<Map<String, Object>> readAllItems() {
        return this.container.queryItems("SELECT * FROM c", null, Map.class).stream().map(i -> i).collect(Collectors.toList());
    }

    public int create(Map<String, Object> document) {
        this.container.createItem(document, PartitionKey.NONE, null);
        return 1;
    }

    public int create(T item) {
        Map<String, Object> document = this.converter.toDocument(item);
        return this.create((T)document);
    }

    public int replace(Map<String, Object> document) {
        this.container.replaceItem(document, (String)document.get("id"), PartitionKey.NONE, null);
        return 1;
    }

    public int replace(T item) {
        Map<String, Object> document = this.converter.toDocument(item);
        return this.replace((T)document);
    }

    public int upsert(Map<String, Object> document) {
        this.container.upsertItem(document, null);
        return 1;
    }

    public int upsert(T item) {
        Map<String, Object> document = this.converter.toDocument(item);
        return this.upsert((T)document);
    }

    public int delete(Map<String, Object> document) {
        this.container.deleteItem((String)document.get("id"), PartitionKey.NONE, null);
        return 1;
    }

    public int delete(T item) {
        Map<String, Object> document = this.converter.toDocument(item);
        return this.delete((T)document);
    }

    public boolean exists(String id) {
        SqlQuerySpec querySpec = new SqlQuerySpec("SELECT * FROM c WHERE c.id=@id", new SqlParameter[]{new SqlParameter("@id", (Object)id)});
        return 1L == this.container.queryItems(querySpec, null, Map.class).stream().count();
    }

    public CosmosContainer getContainer() {
        return this.container;
    }

    public AbstractItemToDocumentConverter<T, Map<String, Object>> getConverter() {
        return this.converter;
    }
}

