/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.Optional;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class CreateContainerStatement
extends AbstractCosmosStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "createContainer";
    private final String containerId;
    private final String containerProperties;
    private final String throughputProperties;
    private final Boolean skipExisting;

    public CreateContainerStatement(String containerId, String containerProperties, String throughputProperties) {
        this(containerId, containerProperties, throughputProperties, Boolean.FALSE);
    }

    public CreateContainerStatement(String containerId, String containerProperties) {
        this(containerId, containerProperties, null);
    }

    public CreateContainerStatement(String containerId) {
        this(containerId, null);
    }

    public CreateContainerStatement() {
        this(null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + this.getContainerId() + ", " + this.getContainerProperties() + ", " + this.getThroughputProperties() + ", " + this.getSkipExisting() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainerProperties cosmosContainerProperties = JsonUtils.toContainerProperties(this.getContainerId(), this.getContainerProperties());
        ThroughputProperties cosmosThroughputProperties = JsonUtils.toThroughputProperties(this.getThroughputProperties());
        if (Optional.ofNullable(this.skipExisting).orElse(Boolean.FALSE).booleanValue()) {
            database.getCosmosDatabase().createContainerIfNotExists(cosmosContainerProperties, cosmosThroughputProperties);
        } else {
            database.getCosmosDatabase().createContainer(cosmosContainerProperties, cosmosThroughputProperties);
        }
    }

    public CreateContainerStatement(String containerId, String containerProperties, String throughputProperties, Boolean skipExisting) {
        this.containerId = containerId;
        this.containerProperties = containerProperties;
        this.throughputProperties = throughputProperties;
        this.skipExisting = skipExisting;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerProperties() {
        return this.containerProperties;
    }

    public String getThroughputProperties() {
        return this.throughputProperties;
    }

    public Boolean getSkipExisting() {
        return this.skipExisting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateContainerStatement)) {
            return false;
        }
        CreateContainerStatement other = (CreateContainerStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$skipExisting = this.getSkipExisting();
        Boolean other$skipExisting = other.getSkipExisting();
        if (this$skipExisting == null ? other$skipExisting != null : !((Object)this$skipExisting).equals(other$skipExisting)) {
            return false;
        }
        String this$containerId = this.getContainerId();
        String other$containerId = other.getContainerId();
        if (this$containerId == null ? other$containerId != null : !this$containerId.equals(other$containerId)) {
            return false;
        }
        String this$containerProperties = this.getContainerProperties();
        String other$containerProperties = other.getContainerProperties();
        if (this$containerProperties == null ? other$containerProperties != null : !this$containerProperties.equals(other$containerProperties)) {
            return false;
        }
        String this$throughputProperties = this.getThroughputProperties();
        String other$throughputProperties = other.getThroughputProperties();
        return !(this$throughputProperties == null ? other$throughputProperties != null : !this$throughputProperties.equals(other$throughputProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateContainerStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $skipExisting = this.getSkipExisting();
        result = result * 59 + ($skipExisting == null ? 43 : ((Object)$skipExisting).hashCode());
        String $containerId = this.getContainerId();
        result = result * 59 + ($containerId == null ? 43 : $containerId.hashCode());
        String $containerProperties = this.getContainerProperties();
        result = result * 59 + ($containerProperties == null ? 43 : $containerProperties.hashCode());
        String $throughputProperties = this.getThroughputProperties();
        result = result * 59 + ($throughputProperties == null ? 43 : $throughputProperties.hashCode());
        return result;
    }
}

