/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class CreateItemStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "createItem";
    private final Document document;

    public CreateItemStatement() {
        this(null, (String)null);
    }

    public CreateItemStatement(String containerId, String jsonDocument) {
        this(containerId, JsonUtils.orEmptyDocument(jsonDocument));
    }

    public CreateItemStatement(String containerId, Document document) {
        super(containerId);
        this.document = document;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.containerId + "." + this.getCommandName() + "(" + this.document.toJson() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerId);
        cosmosContainer.createItem((Object)this.document);
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateItemStatement)) {
            return false;
        }
        CreateItemStatement other = (CreateItemStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateItemStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }
}

