/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosContainerProperties;
import java.util.Collections;
import java.util.List;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosStatement;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class DeleteAllContainersStatement
extends AbstractCosmosStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "deleteAllContainers";
    final List<String> ignoreContainerIds;

    public DeleteAllContainersStatement() {
        this(Collections.emptyList());
    }

    public DeleteAllContainersStatement(List<String> ignoreContainerIds) {
        this.ignoreContainerIds = ignoreContainerIds;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + this.ignoreContainerIds.toString() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        database.getCosmosDatabase().readAllContainers().stream().map(CosmosContainerProperties::getId).filter(id -> !this.ignoreContainerIds.contains(id)).map(id -> database.getCosmosDatabase().getContainer(id)).forEach(CosmosContainer::delete);
    }
}

