/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosContainerProperties;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class DeleteContainerStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "delete";
    private final Boolean skipMissing;

    public DeleteContainerStatement(String containerId, Boolean skipMissing) {
        super(containerId);
        this.skipMissing = skipMissing;
    }

    public DeleteContainerStatement(String containerId) {
        this(containerId, Boolean.FALSE);
    }

    public DeleteContainerStatement() {
        this(null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getContainerId() + "." + this.getCommandName() + "(" + this.skipMissing + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        if (Boolean.TRUE.equals(this.skipMissing) && database.getCosmosDatabase().readAllContainers().stream().map(CosmosContainerProperties::getId).noneMatch(c -> c.equals(this.containerId))) {
            return;
        }
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerId);
        cosmosContainer.delete();
    }

    public Boolean getSkipMissing() {
        return this.skipMissing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteContainerStatement)) {
            return false;
        }
        DeleteContainerStatement other = (DeleteContainerStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$skipMissing = this.getSkipMissing();
        Boolean other$skipMissing = other.getSkipMissing();
        return !(this$skipMissing == null ? other$skipMissing != null : !((Object)this$skipMissing).equals(other$skipMissing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteContainerStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $skipMissing = this.getSkipMissing();
        result = result * 59 + ($skipMissing == null ? 43 : ((Object)$skipMissing).hashCode());
        return result;
    }
}

