/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.node.ObjectNode;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class DeleteEachItemStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "deleteEachItem";
    private final SqlQuerySpec query;

    public DeleteEachItemStatement(String containerId, String jsonQuery) {
        super(containerId);
        this.query = JsonUtils.orEmptySqlQuerySpec(jsonQuery);
    }

    public DeleteEachItemStatement(String containerId, SqlQuerySpec query) {
        super(containerId);
        this.query = query;
    }

    public DeleteEachItemStatement() {
        this(null, (String)null);
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerId);
        String partitionKeyPath = JsonUtils.extractPartitionKeyPath(cosmosContainer);
        cosmosContainer.queryItems(this.query, null, ObjectNode.class).stream().map(Document::new).forEach(document -> {
            PartitionKey partitionKey = JsonUtils.extractPartitionKeyByPath(document, partitionKeyPath);
            cosmosContainer.deleteItem((String)document.get("id"), partitionKey, null);
        });
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }
}

