/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import java.util.Optional;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.AbstractCosmosContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;

public class DeleteStoredProcedureStatement
extends AbstractCosmosContainerStatement
implements NoSqlExecuteStatement<CosmosLiquibaseDatabase> {
    public static final String COMMAND_NAME = "deleteStoredProcedure";
    private final CosmosStoredProcedureProperties procedureProperties;
    private final Boolean skipMissing;

    public DeleteStoredProcedureStatement(String containerId, String procedurePropertiesJson, Boolean skipMissing) {
        this(containerId, JsonUtils.orEmptyStoredProcedureProperties(procedurePropertiesJson), skipMissing);
    }

    public DeleteStoredProcedureStatement(String containerId, CosmosStoredProcedureProperties procedureProperties, Boolean skipMissing) {
        super(containerId);
        this.procedureProperties = procedureProperties;
        this.skipMissing = Optional.ofNullable(skipMissing).orElse(Boolean.FALSE);
    }

    public DeleteStoredProcedureStatement() {
        this(null, (String)null, null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getContainerId() + "." + this.getCommandName() + "(" + this.procedureProperties.toString() + ");";
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosScripts cosmosScripts = database.getCosmosDatabase().getContainer(this.getContainerId()).getScripts();
        if (this.skipMissing.booleanValue() && cosmosScripts.readAllStoredProcedures().stream().noneMatch(p -> p.getId().equals(this.procedureProperties.getId()))) {
            return;
        }
        cosmosScripts.getStoredProcedure(this.procedureProperties.getId()).delete();
    }

    public CosmosStoredProcedureProperties getProcedureProperties() {
        return this.procedureProperties;
    }

    public Boolean getSkipMissing() {
        return this.skipMissing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteStoredProcedureStatement)) {
            return false;
        }
        DeleteStoredProcedureStatement other = (DeleteStoredProcedureStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$skipMissing = this.getSkipMissing();
        Boolean other$skipMissing = other.getSkipMissing();
        if (this$skipMissing == null ? other$skipMissing != null : !((Object)this$skipMissing).equals(other$skipMissing)) {
            return false;
        }
        CosmosStoredProcedureProperties this$procedureProperties = this.getProcedureProperties();
        CosmosStoredProcedureProperties other$procedureProperties = other.getProcedureProperties();
        return !(this$procedureProperties == null ? other$procedureProperties != null : !this$procedureProperties.equals(other$procedureProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteStoredProcedureStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $skipMissing = this.getSkipMissing();
        result = result * 59 + ($skipMissing == null ? 43 : ((Object)$skipMissing).hashCode());
        CosmosStoredProcedureProperties $procedureProperties = this.getProcedureProperties();
        result = result * 59 + ($procedureProperties == null ? 43 : $procedureProperties.hashCode());
        return result;
    }
}

