/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.Objects;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CreateContainerStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;
import liquibase.util.StringUtil;

public class ReplaceContainerStatement
extends CreateContainerStatement {
    public static final String COMMAND_NAME = "replaceContainer";

    public ReplaceContainerStatement(String containerId, String containerProperties, String throughputProperties) {
        super(containerId, containerProperties, throughputProperties);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainerProperties cosmosContainerProperties;
        if (Objects.nonNull(StringUtil.trimToNull((String)this.getContainerProperties()))) {
            cosmosContainerProperties = JsonUtils.toContainerProperties(this.getContainerId(), this.getContainerProperties());
            database.getCosmosDatabase().getContainer(this.getContainerId()).replace(cosmosContainerProperties);
        }
        if (Objects.nonNull(StringUtil.trimToNull((String)this.getThroughputProperties()))) {
            cosmosContainerProperties = JsonUtils.toThroughputProperties(this.getThroughputProperties());
            database.getCosmosDatabase().getContainer(this.getContainerId()).replaceThroughput((ThroughputProperties)cosmosContainerProperties);
        }
    }

    public ReplaceContainerStatement() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceContainerStatement)) {
            return false;
        }
        ReplaceContainerStatement other = (ReplaceContainerStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceContainerStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

