/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.node.ObjectNode;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CreateItemStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;

public class UpdateEachItemStatement
extends CreateItemStatement {
    public static final String COMMAND_NAME = "updateEachItem";
    private final SqlQuerySpec query;

    public UpdateEachItemStatement(String containerId, String jsonQuery, String jsonDocument) {
        super(containerId, jsonDocument);
        this.query = JsonUtils.orEmptySqlQuerySpec(jsonQuery);
    }

    public UpdateEachItemStatement(String containerId, SqlQuerySpec query, Document document) {
        super(containerId, document);
        this.query = query;
    }

    public UpdateEachItemStatement() {
        this(null, (SqlQuerySpec)null, null);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.containerId);
        String partitionKeyPath = JsonUtils.extractPartitionKeyPath(cosmosContainer);
        Document source = this.getDocument();
        cosmosContainer.queryItems(this.query, null, ObjectNode.class).stream().map(Document::new).map(d -> JsonUtils.mergeDocuments(d, source)).forEach(destination -> {
            PartitionKey partitionKey = JsonUtils.extractPartitionKeyByPath(destination, partitionKeyPath);
            cosmosContainer.upsertItem(destination, partitionKey, null);
        });
    }
}

