/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.statement;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.models.PartitionKey;
import liquibase.ext.cosmosdb.database.CosmosLiquibaseDatabase;
import liquibase.ext.cosmosdb.statement.CreateItemStatement;
import liquibase.ext.cosmosdb.statement.JsonUtils;

public class UpsertItemStatement
extends CreateItemStatement {
    public static final String COMMAND_NAME = "upsertItem";

    public UpsertItemStatement(String containerId, String jsonDocument) {
        this(containerId, JsonUtils.orEmptyDocument(jsonDocument));
    }

    public UpsertItemStatement(String containerId, Document document) {
        super(containerId, document);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(CosmosLiquibaseDatabase database) {
        CosmosContainer cosmosContainer = database.getCosmosDatabase().getContainer(this.getContainerId());
        PartitionKey key = JsonUtils.extractPartitionKey(this.getDocument(), cosmosContainer);
        cosmosContainer.upsertItem((Object)this.getDocument(), key, null);
    }

    @Override
    public String toString() {
        return this.toJs();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpsertItemStatement)) {
            return false;
        }
        UpsertItemStatement other = (UpsertItemStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpsertItemStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

