/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.util.Collections;
import javax.persistence.spi.PersistenceUnitInfo;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import liquibase.ext.hibernate.database.connection.HibernateDriver;
import org.hibernate.cfg.Configuration;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.service.ServiceRegistry;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;

public class JpaPersistenceDatabase
extends HibernateDatabase {
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("jpa:persistence:");
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jpa:persistence:")) {
            return HibernateDriver.class.getName();
        }
        return null;
    }

    @Override
    protected Configuration buildConfiguration(HibernateConnection connection) throws DatabaseException {
        return this.buildConfigurationFromXml(connection);
    }

    protected Configuration buildConfigurationFromXml(HibernateConnection connection) {
        DefaultPersistenceUnitManager internalPersistenceUnitManager = new DefaultPersistenceUnitManager();
        internalPersistenceUnitManager.setPersistenceXmlLocation(connection.getPath());
        internalPersistenceUnitManager.setDefaultPersistenceUnitRootLocation(null);
        internalPersistenceUnitManager.preparePersistenceUnitInfos();
        PersistenceUnitInfo persistenceUnitInfo = internalPersistenceUnitManager.obtainDefaultPersistenceUnitInfo();
        EntityManagerFactoryBuilderImpl builder = (EntityManagerFactoryBuilderImpl)Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitInfo)persistenceUnitInfo, Collections.emptyMap(), null);
        ServiceRegistry serviceRegistry = builder.buildServiceRegistry();
        return builder.buildHibernateConfiguration(serviceRegistry);
    }

    public String getShortName() {
        return "jpaPersistence";
    }

    protected String getDefaultDatabaseProductName() {
        return "JPA Persistence";
    }
}

