/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.ext.hibernate.snapshot.extension.ExtendedSnapshotGenerator;
import liquibase.ext.hibernate.snapshot.extension.MultipleHiLoPerTableSnapshotGenerator;
import liquibase.ext.hibernate.snapshot.extension.TableGeneratorSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import org.hibernate.cfg.Configuration;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;

public class TableSnapshotGenerator
extends HibernateSnapshotGenerator {
    private List<ExtendedSnapshotGenerator<IdentifierGenerator, liquibase.structure.core.Table>> tableIdGenerators = new ArrayList<ExtendedSnapshotGenerator<IdentifierGenerator, liquibase.structure.core.Table>>();

    public TableSnapshotGenerator() {
        super(liquibase.structure.core.Table.class, new Class[]{Schema.class});
        this.tableIdGenerators.add(new MultipleHiLoPerTableSnapshotGenerator());
        this.tableIdGenerators.add(new TableGeneratorSnapshotGenerator());
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        Table hibernateTable = this.findHibernateTable(example, snapshot);
        if (hibernateTable == null) {
            return example;
        }
        liquibase.structure.core.Table table = new liquibase.structure.core.Table().setName(hibernateTable.getName());
        LOG.info("Found table " + table.getName());
        table.setSchema(example.getSchema());
        return table;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(liquibase.structure.core.Table.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            Configuration cfg = database.getConfiguration();
            Iterator tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                Table hibernateTable = (Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                liquibase.structure.core.Table table = new liquibase.structure.core.Table().setName(hibernateTable.getName());
                table.setSchema(schema);
                LOG.info("Found table " + table.getName());
                schema.addDatabaseObject(this.snapshotObject((DatabaseObject)table, snapshot));
            }
            Iterator classMappings = cfg.getClassMappings();
            block1: while (classMappings.hasNext()) {
                PersistentClass persistentClass = (PersistentClass)classMappings.next();
                if (persistentClass.isInherited()) continue;
                IdentifierGenerator ig = persistentClass.getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)cfg.getIdentifierGeneratorFactory(), database.getDialect(), null, null, (RootClass)persistentClass);
                for (ExtendedSnapshotGenerator<IdentifierGenerator, liquibase.structure.core.Table> tableIdGenerator : this.tableIdGenerators) {
                    if (!tableIdGenerator.supports(ig)) continue;
                    liquibase.structure.core.Table idTable = tableIdGenerator.snapshot(ig);
                    idTable.setSchema(schema);
                    schema.addDatabaseObject(this.snapshotObject((DatabaseObject)idTable, snapshot));
                    continue block1;
                }
            }
        }
    }

    private boolean isAutoIncrement(LiquibaseDataType dataType) {
        Method[] methods;
        boolean retVal = false;
        String methodName = "isAutoIncrement";
        for (Method method : methods = dataType.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
            retVal = true;
            break;
        }
        return retVal;
    }
}

