/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;

public class PrimaryKeySnapshotGenerator
extends HibernateSnapshotGenerator {
    private static final int PKNAMELENGTH = 63;
    private static final String PK = "PK";
    private static final Alias PK_ALIAS_15 = new Alias(15, "PK");
    private static final Alias NEW_PK_ALIAS = new Alias(63, "PK");

    public PrimaryKeySnapshotGenerator() {
        super(PrimaryKey.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(PrimaryKey.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            if (hibernateTable == null) {
                return;
            }
            org.hibernate.mapping.PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
            if (hibernatePrimaryKey != null) {
                PrimaryKey pk = new PrimaryKey();
                Object hbnPrimaryKeyName = hibernatePrimaryKey.getName();
                String hbnTableName = hibernateTable.getName();
                if (hbnPrimaryKeyName != null && ((String)hbnPrimaryKeyName).length() == 15 && ((String)hbnPrimaryKeyName).equals(PK_ALIAS_15.toAliasString(hbnTableName))) {
                    LOG.warning("Hibernate primary key name is probably truncated. " + (String)hbnPrimaryKeyName);
                    String newAlias = NEW_PK_ALIAS.toAliasString(hbnTableName);
                    int newAliasLength = newAlias.length();
                    if (newAliasLength > 15) {
                        if (newAliasLength == 63) {
                            String suffix = "_" + Integer.toHexString(hbnTableName.hashCode()).toUpperCase() + "_" + PK;
                            hbnPrimaryKeyName = newAlias.substring(0, 63 - suffix.length()) + suffix;
                        } else {
                            hbnPrimaryKeyName = newAlias;
                        }
                        LOG.warning("Changing hibernate primary key name to " + (String)hbnPrimaryKeyName);
                    }
                }
                pk.setName((String)hbnPrimaryKeyName);
                pk.setTable(table);
                for (Object hibernateColumn : hibernatePrimaryKey.getColumns()) {
                    pk.getColumns().add(new liquibase.structure.core.Column(((Column)hibernateColumn).getName()).setRelation((Relation)table));
                }
                LOG.info("Found primary key " + pk.getName());
                table.setPrimaryKey(pk);
                Index index = new Index();
                index.setName("IX_" + pk.getName());
                index.setTable((Relation)table);
                index.setColumns(pk.getColumns());
                index.setUnique(Boolean.valueOf(true));
                pk.setBackingIndex(index);
                table.getIndexes().add(index);
            }
        }
    }
}

