/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;

public class PrimaryKeySnapshotGenerator
extends HibernateSnapshotGenerator {
    private static final int PK_NAME_LENGTH = 63;
    private static final String PK_NAME_SUFFIX = "PK";
    private static final Alias PK_NAME_ALIAS = new Alias(63, "PK");

    public PrimaryKeySnapshotGenerator() {
        super(PrimaryKey.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(PrimaryKey.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            if (hibernateTable == null) {
                return;
            }
            org.hibernate.mapping.PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
            if (hibernatePrimaryKey != null) {
                PrimaryKey pk = new PrimaryKey();
                String hbnTableName = hibernateTable.getName();
                String pkName = PK_NAME_ALIAS.toAliasString(hbnTableName);
                if (pkName.length() == 63) {
                    String suffix = "_" + Integer.toHexString(hbnTableName.hashCode()).toUpperCase() + "_" + PK_NAME_SUFFIX;
                    pkName = pkName.substring(0, 63 - suffix.length()) + (String)suffix;
                }
                pk.setName(pkName);
                pk.setTable(table);
                for (Column hibernateColumn : hibernatePrimaryKey.getColumns()) {
                    pk.getColumns().add(new liquibase.structure.core.Column(hibernateColumn.getName()).setRelation((Relation)table));
                }
                Scope.getCurrentScope().getLog(this.getClass()).info("Found primary key " + pk.getName());
                table.setPrimaryKey(pk);
                Index index = new Index();
                index.setName("IX_" + pk.getName());
                index.setRelation((Relation)table);
                index.setColumns(pk.getColumns());
                index.setUnique(Boolean.valueOf(true));
                pk.setBackingIndex(index);
                table.getIndexes().add(index);
            }
        }
    }
}

