/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import java.util.Collections;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.query.Query;

public abstract class AbstractRelationQueryGenerator
implements RelationQueryGenerator {
    protected final GlobalConfiguration globalCfg;
    protected final AuditEntitiesConfiguration verEntCfg;
    protected final AuditStrategy auditStrategy;
    protected final MiddleIdData referencingIdData;
    protected final boolean revisionTypeInId;
    protected final String entityName;
    protected final String orderBy;
    private String queryString;
    private String queryRemovedString;

    protected AbstractRelationQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, String entityName, MiddleIdData referencingIdData, boolean revisionTypeInId, String orderBy) {
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.entityName = entityName;
        this.auditStrategy = auditStrategy;
        this.referencingIdData = referencingIdData;
        this.revisionTypeInId = revisionTypeInId;
        this.orderBy = orderBy;
    }

    @Override
    public Query getQuery(SharedSessionContractImplementor session, Object primaryKey, Number revision, boolean removed) {
        String queryString = this.getQueryString(session.getFactory(), removed);
        Query query = session.createQuery(queryString);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        query.setParameter("revision", (Object)revision);
        IdMapper prefixIdMapper = this.referencingIdData.getPrefixedMapper();
        for (QueryParameterData paramData : prefixIdMapper.mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }

    protected abstract QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor var1);

    protected abstract void applyValidPredicates(QueryBuilder var1, Parameters var2, boolean var3);

    protected abstract void applyValidAndRemovePredicates(QueryBuilder var1);

    protected String getRevisionTypePath() {
        if (this.revisionTypeInId) {
            return this.verEntCfg.getOriginalIdPropName() + "." + this.verEntCfg.getRevisionTypePropName();
        }
        return this.verEntCfg.getRevisionTypePropName();
    }

    private String getQueryString(SessionFactoryImplementor sessionFactory, boolean removed) {
        if (removed) {
            if (this.queryRemovedString == null) {
                this.queryRemovedString = this.buildQueryRemoveString(sessionFactory);
            }
            return this.queryRemovedString;
        }
        if (this.queryString == null) {
            this.queryString = this.buildQueryString(sessionFactory);
        }
        return this.queryString;
    }

    private String buildQueryString(SessionFactoryImplementor sessionFactory) {
        QueryBuilder builder = this.buildQueryBuilderCommon(sessionFactory);
        this.applyValidPredicates(builder, builder.getRootParameters(), true);
        return this.queryToString(builder);
    }

    private String buildQueryRemoveString(SessionFactoryImplementor sessionFactory) {
        QueryBuilder builder = this.buildQueryBuilderCommon(sessionFactory);
        this.applyValidAndRemovePredicates(builder);
        return this.queryToString(builder);
    }

    private String queryToString(QueryBuilder query) {
        return this.queryToString(query, Collections.emptyMap());
    }

    private String queryToString(QueryBuilder query, Map<String, Object> queryParamValues) {
        StringBuilder sb = new StringBuilder();
        query.build(sb, queryParamValues);
        return sb.toString();
    }
}

