/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.event.spi.EventSource;

public class AuditProcessManager {
    private final Map<Transaction, AuditProcess> auditProcesses = new ConcurrentHashMap<Transaction, AuditProcess>();
    private final RevisionInfoGenerator revisionInfoGenerator;

    public AuditProcessManager(RevisionInfoGenerator revisionInfoGenerator) {
        this.revisionInfoGenerator = revisionInfoGenerator;
    }

    public AuditProcess get(EventSource session) {
        final Transaction transaction = session.accessTransaction();
        AuditProcess auditProcess = this.auditProcesses.get(transaction);
        if (auditProcess == null) {
            auditProcess = new AuditProcess(this.revisionInfoGenerator, session);
            this.auditProcesses.put(transaction, auditProcess);
            session.getActionQueue().registerProcess(new BeforeTransactionCompletionProcess(){

                @Override
                public void doBeforeTransactionCompletion(SessionImplementor session) {
                    AuditProcess process = (AuditProcess)AuditProcessManager.this.auditProcesses.get(transaction);
                    if (process != null) {
                        process.doBeforeTransactionCompletion(session);
                    }
                }
            });
            session.getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                @Override
                public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) {
                    AuditProcessManager.this.auditProcesses.remove(transaction);
                }
            });
        }
        return auditProcess;
    }
}

