/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.tools.Pair;
import org.hibernate.internal.util.collections.ConcurrentReferenceHashMap;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.PropertyAccessStrategyResolver;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public abstract class ReflectionTools {
    private static final Map<Pair<Class, String>, Getter> GETTER_CACHE = new ConcurrentReferenceHashMap<Pair<Class, String>, Getter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private static final Map<Pair<Class, String>, Setter> SETTER_CACHE = new ConcurrentReferenceHashMap<Pair<Class, String>, Setter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private static PropertyAccessStrategy getAccessStrategy(Class<?> cls, ServiceRegistry serviceRegistry, String accessorType) {
        return serviceRegistry.getService(PropertyAccessStrategyResolver.class).resolvePropertyAccessStrategy(cls, accessorType, null);
    }

    public static Getter getGetter(Class cls, PropertyData propertyData, ServiceRegistry serviceRegistry) {
        return ReflectionTools.getGetter(cls, propertyData.getBeanName(), propertyData.getAccessType(), serviceRegistry);
    }

    public static Getter getGetter(Class cls, String propertyName, String accessorType, ServiceRegistry serviceRegistry) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Getter value = GETTER_CACHE.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessStrategy(cls, serviceRegistry, accessorType).buildPropertyAccess(cls, propertyName).getGetter();
            GETTER_CACHE.put(key, value);
        }
        return value;
    }

    public static Setter getSetter(Class cls, PropertyData propertyData, ServiceRegistry serviceRegistry) {
        return ReflectionTools.getSetter(cls, propertyData.getBeanName(), propertyData.getAccessType(), serviceRegistry);
    }

    public static Setter getSetter(Class cls, String propertyName, String accessorType, ServiceRegistry serviceRegistry) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Setter value = SETTER_CACHE.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessStrategy(cls, serviceRegistry, accessorType).buildPropertyAccess(cls, propertyName).getSetter();
            SETTER_CACHE.put(key, value);
        }
        return value;
    }

    public static Field getField(Class cls, PropertyData propertyData) {
        Field field = null;
        for (Class clazz = cls; clazz != null && field == null; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(propertyData.getName());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return field;
    }

    public static Class<?> getType(Class cls, PropertyData propertyData, ServiceRegistry serviceRegistry) {
        Setter setter = ReflectionTools.getSetter(cls, propertyData, serviceRegistry);
        if (setter.getMethod() != null && setter.getMethod().getParameterCount() > 0) {
            return setter.getMethod().getParameterTypes()[0];
        }
        Field field = ReflectionTools.getField(cls, propertyData);
        if (field != null) {
            return field.getType();
        }
        throw new AuditException(String.format(Locale.ROOT, "Failed to determine type for field [%s] on class [%s].", propertyData.getName(), cls.getName()));
    }

    public static XProperty getProperty(XClass clazz, String propertyName) {
        XProperty property = ReflectionTools.getProperty(clazz, propertyName, "field");
        if (property == null) {
            property = ReflectionTools.getProperty(clazz, propertyName, "property");
        }
        return property;
    }

    public static XProperty getProperty(XClass clazz, String propertyName, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static <T> Class<T> loadClass(String name, ClassLoaderService classLoaderService) throws ClassLoadingException {
        try {
            if (classLoaderService != null) {
                return classLoaderService.classForName(name);
            }
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            throw new ClassLoadingException("Unable to load class [" + name + "]", e);
        }
    }
}

