/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;

public class HibernateClassicDatabase
extends HibernateDatabase {
    protected Configuration configuration;

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:classic:");
    }

    @Override
    protected String findDialectName() {
        String dialectName = super.findDialectName();
        if (dialectName == null) {
            dialectName = this.configuration.getProperty("hibernate.dialect");
        }
        return dialectName;
    }

    @Override
    protected Metadata buildMetadataFromPath() throws DatabaseException {
        this.configuration = new Configuration();
        this.configuration.configure(this.getHibernateConnection().getPath());
        return super.buildMetadataFromPath();
    }

    @Override
    protected void configureSources(MetadataSources sources) throws DatabaseException {
        Configuration config = new Configuration(sources);
        config.configure(this.getHibernateConnection().getPath());
        config.setProperty("hibernate.temp.use_jdbc_metadata_defaults", "false");
        config.setProperty("hibernate.cache.use_second_level_cache", "false");
        StandardServiceRegistry standardRegistry = this.configuration.getStandardServiceRegistryBuilder().applySettings(config.getProperties()).addService(ConnectionProvider.class, (Service)new HibernateDatabase.NoOpConnectionProvider()).addService(MultiTenantConnectionProvider.class, (Service)new HibernateDatabase.NoOpConnectionProvider()).build();
        config.buildSessionFactory((ServiceRegistry)standardRegistry);
    }

    public String getShortName() {
        return "hibernateClassic";
    }

    protected String getDefaultDatabaseProductName() {
        return "Hibernate Classic";
    }
}

