/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.DialectOverride;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.ForeignKeyType;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.type.descriptor.java.JavaType;

public class BinderHelper {
    public static final Set<String> PRIMITIVE_NAMES = Set.of(Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.TYPE.getName());

    private BinderHelper() {
    }

    public static boolean isPrimitive(String elementTypeName) {
        return PRIMITIVE_NAMES.contains(elementTypeName);
    }

    public static void createSyntheticPropertyReference(AnnotatedJoinColumns joinColumns, PersistentClass targetEntity, PersistentClass associatedEntity, Value value, String propertyName, boolean inverse, MetadataBuildingContext context) {
        if (joinColumns.getReferencedColumnsType(targetEntity) == ForeignKeyType.NON_PRIMARY_KEY_REFERENCE) {
            AttributeContainer columnOwner = BinderHelper.findReferencedColumnOwner(targetEntity, joinColumns.getJoinColumns().get(0), context);
            BinderHelper.checkColumnInSameTable(joinColumns, targetEntity, associatedEntity, context, columnOwner);
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, joinColumns, associatedEntity, context);
            Property property = BinderHelper.referencedProperty(targetEntity, associatedEntity, propertyName, inverse, columnOwner, properties, context);
            BinderHelper.registerSyntheticProperty(targetEntity, value, inverse, associatedEntity, propertyName, property.getName(), context);
        }
    }

    private static void checkColumnInSameTable(AnnotatedJoinColumns joinColumns, PersistentClass targetEntity, PersistentClass associatedEntity, MetadataBuildingContext context, Object columnOwner) {
        if (joinColumns.hasMappedBy()) {
            throw new AssertionFailure("no need to create synthetic properties for unowned collections");
        }
        for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
            AttributeContainer owner = BinderHelper.findReferencedColumnOwner(targetEntity, column, context);
            if (owner == null) {
                throw new AnnotationException("A '@JoinColumn' for association " + BinderHelper.associationMessage(associatedEntity, joinColumns) + " references a column named '" + column.getReferencedColumn() + "' which is not mapped by the target entity '" + targetEntity.getEntityName() + "'");
            }
            if (owner == columnOwner) continue;
            AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
            throw new AnnotationException("The '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, joinColumns) + " reference columns of different tables mapped by the target entity '" + targetEntity.getEntityName() + "' ('" + column.getReferencedColumn() + "' belongs to a different table to '" + firstColumn.getReferencedColumn() + "'");
        }
    }

    private static Property referencedProperty(PersistentClass ownerEntity, PersistentClass associatedEntity, String propertyName, boolean inverse, AttributeContainer columnOwner, List<Property> properties, MetadataBuildingContext context) {
        if (properties.size() == 1 && ownerEntity == columnOwner && !(properties.get(0).getValue() instanceof ToOne)) {
            return properties.get(0);
        }
        String syntheticPropertyName = BinderHelper.syntheticPropertyName(propertyName, inverse, associatedEntity);
        return BinderHelper.makeSyntheticComponentProperty(ownerEntity, columnOwner, context, syntheticPropertyName, properties);
    }

    private static void registerSyntheticProperty(PersistentClass ownerEntity, Value value, boolean inverse, PersistentClass associatedClass, String propertyName, String syntheticPropertyName, MetadataBuildingContext context) {
        if (value instanceof ToOne) {
            ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
            ((ToOne)value).setReferenceToPrimaryKey(false);
            context.getMetadataCollector().addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else if (value instanceof Collection) {
            ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
            context.getMetadataCollector().addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else {
            throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
        }
        context.getMetadataCollector().addPropertyReferencedAssociation((inverse ? "inverse__" : "") + associatedClass.getEntityName(), propertyName, syntheticPropertyName);
    }

    private static String syntheticPropertyName(String propertyName, boolean inverse, PersistentClass associatedClass) {
        String syntheticPropertyName = ("_" + associatedClass.getEntityName() + "_" + propertyName).replace('.', '_');
        return inverse ? syntheticPropertyName + "_inverse" : syntheticPropertyName;
    }

    private static String associationMessage(PersistentClass associatedEntity, AnnotatedJoinColumns joinColumns) {
        if (associatedEntity != null) {
            return "'" + associatedEntity.getEntityName() + "." + joinColumns.getPropertyName() + "'";
        }
        if (joinColumns.getPropertyHolder() != null) {
            return "'" + joinColumns.getPropertyHolder().getEntityName() + "." + joinColumns.getPropertyName() + "'";
        }
        return "";
    }

    private static Property makeSyntheticComponentProperty(PersistentClass ownerEntity, AttributeContainer persistentClassOrJoin, MetadataBuildingContext context, String syntheticPropertyName, List<Property> properties) {
        Component embeddedComponent = persistentClassOrJoin instanceof PersistentClass ? new Component(context, (PersistentClass)persistentClassOrJoin) : new Component(context, (Join)persistentClassOrJoin);
        embeddedComponent.setComponentClassName(embeddedComponent.getOwner().getClassName());
        embeddedComponent.setEmbedded(true);
        for (Property property : properties) {
            embeddedComponent.addProperty(BinderHelper.cloneProperty(ownerEntity, context, property));
        }
        embeddedComponent.sortProperties();
        SyntheticProperty result = new SyntheticProperty();
        result.setName(syntheticPropertyName);
        result.setPersistentClass(ownerEntity);
        result.setUpdateable(false);
        result.setInsertable(false);
        result.setValue(embeddedComponent);
        result.setPropertyAccessorName("embedded");
        if (persistentClassOrJoin instanceof Join) {
            persistentClassOrJoin.addProperty(result);
        } else {
            ownerEntity.addProperty(result);
        }
        embeddedComponent.createUniqueKey();
        return result;
    }

    private static Property cloneProperty(PersistentClass ownerEntity, MetadataBuildingContext context, Property property) {
        if (property.isComposite()) {
            Component component = (Component)property.getValue();
            Component copy = new Component(context, component);
            copy.setComponentClassName(component.getComponentClassName());
            copy.setEmbedded(component.isEmbedded());
            for (Property subproperty : component.getProperties()) {
                copy.addProperty(BinderHelper.cloneProperty(ownerEntity, context, subproperty));
            }
            copy.sortProperties();
            SyntheticProperty result = new SyntheticProperty();
            result.setName(property.getName());
            result.setPersistentClass(ownerEntity);
            result.setUpdateable(false);
            result.setInsertable(false);
            result.setValue(copy);
            result.setPropertyAccessorName(property.getPropertyAccessorName());
            return result;
        }
        Property clone = BinderHelper.shallowCopy(property);
        clone.setInsertable(false);
        clone.setUpdateable(false);
        clone.setNaturalIdentifier(false);
        clone.setValueGeneratorCreator(property.getValueGeneratorCreator());
        return clone;
    }

    public static Property shallowCopy(Property property) {
        SyntheticProperty clone = new SyntheticProperty();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Property> findPropertiesByColumns(Object columnOwner, AnnotatedJoinColumns columns, PersistentClass associatedEntity, MetadataBuildingContext context) {
        Table referencedTable;
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure((String)(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass()));
        }
        ArrayList<org.hibernate.mapping.Column> orderedColumns = new ArrayList<org.hibernate.mapping.Column>(columns.getJoinColumns().size());
        HashMap<org.hibernate.mapping.Column, Set<Property>> columnsToProperty = new HashMap<org.hibernate.mapping.Column, Set<Property>>();
        InFlightMetadataCollector collector = context.getMetadataCollector();
        for (AnnotatedJoinColumn annotatedJoinColumn : columns.getJoinColumns()) {
            if (annotatedJoinColumn.isReferenceImplicit()) {
                throw new AnnotationException("Association " + BinderHelper.associationMessage(associatedEntity, columns) + " has a '@JoinColumn' which does not specify the 'referencedColumnName' (when an association has multiple '@JoinColumn's, they must each specify their 'referencedColumnName')");
            }
            String string = collector.getPhysicalColumnName(referencedTable, annotatedJoinColumn.getReferencedColumn());
            org.hibernate.mapping.Column column = new org.hibernate.mapping.Column(string);
            orderedColumns.add(column);
            columnsToProperty.put(column, new LinkedHashSet());
        }
        if (columnOwner instanceof PersistentClass) {
            PersistentClass persistentClass = (PersistentClass)columnOwner;
            for (Property property : persistentClass.getReferenceableProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
            if (persistentClass.hasIdentifierProperty()) {
                BinderHelper.matchColumnsByProperty(persistentClass.getIdentifierProperty(), columnsToProperty);
            } else {
                Component component = persistentClass.getIdentifierMapper();
                for (Property p : component.getProperties()) {
                    BinderHelper.matchColumnsByProperty(p, columnsToProperty);
                }
            }
        } else {
            for (Property property : ((Join)columnOwner).getProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        boolean bl = false;
        Object var10_23 = null;
        for (org.hibernate.mapping.Column column : orderedColumns) {
            boolean bl2;
            void var10_24;
            Set properties = (Set)columnsToProperty.get(column);
            if (properties.isEmpty()) {
                throw new AnnotationException("Referenced column '" + column.getName() + "' in '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " is not mapped by any property of the target entity");
            }
            Iterator iterator = properties.iterator();
            if (!iterator.hasNext()) continue;
            Property property = (Property)iterator.next();
            if (property == var10_24) {
                if (!property.getColumns().get(bl2 ? 1 : 0).equals(column)) {
                    throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, columns));
                }
                if ((bl2 += 1) != var10_24.getColumnSpan()) continue;
                Object var10_25 = null;
                bl2 = false;
                continue;
            }
            if (var10_24 != null) {
                throw new AnnotationException("Target property '" + property.getName() + "' has " + property.getColumnSpan() + " columns which must be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " (every column mapped by '" + property.getName() + "' must occur exactly once as a 'referencedColumnName', and in the correct order)");
            }
            if (orderedProperties.contains(property)) {
                throw new AnnotationException("Target property '" + property.getName() + "' has only " + property.getColumnSpan() + " columns which may be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " (each column mapped by '" + property.getName() + "' may only occur once as a 'referencedColumnName')");
            }
            if (property.getColumnSpan() > 1) {
                if (!property.getColumns().get(0).equals(column)) {
                    throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's");
                }
                Property property2 = property;
                bl2 = true;
            }
            orderedProperties.add(property);
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<org.hibernate.mapping.Column, Set<Property>> columnsToProperty) {
        if (property != null && BuiltInPropertyAccessStrategies.NOOP != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName()) && BuiltInPropertyAccessStrategies.EMBEDDED != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName())) {
            for (Selectable selectable : property.getSelectables()) {
                if (!columnsToProperty.containsKey(selectable)) continue;
                columnsToProperty.get(selectable).add(property);
            }
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty == null ? null : idProperty.getName();
        try {
            if (StringHelper.isEmpty(propertyName) || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String propertyName) {
        Property property = null;
        try {
            if (propertyName == null || propertyName.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(propertyName, ".", false);
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    property = component.getProperty(element);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        return path.length() == entityName.length() ? propertyName : StringHelper.qualify(path.substring(entityName.length() + 1), propertyName);
    }

    public static AttributeContainer findReferencedColumnOwner(PersistentClass persistentClass, AnnotatedJoinColumn joinColumn, MetadataBuildingContext context) {
        return joinColumn.isImplicit() || joinColumn.isReferenceImplicit() ? persistentClass : BinderHelper.findColumnOwner(persistentClass, joinColumn.getReferencedColumn(), context);
    }

    public static AttributeContainer findColumnOwner(PersistentClass persistentClass, String columnName, MetadataBuildingContext context) {
        for (PersistentClass current = persistentClass; current != null; current = current.getSuperclass()) {
            try {
                context.getMetadataCollector().getPhysicalColumnName(current.getTable(), columnName);
                return current;
            }
            catch (MappingException mappingException) {
                for (Join join : current.getJoins()) {
                    try {
                        context.getMetadataCollector().getPhysicalColumnName(join.getTable(), columnName);
                        return join;
                    }
                    catch (MappingException mappingException2) {
                    }
                }
                continue;
            }
        }
        return null;
    }

    public static Any buildAnyValue(Column discriminatorColumn, Formula discriminatorFormula, AnnotatedJoinColumns keyColumns, PropertyData inferredData, OnDeleteAction onDeleteAction, boolean lazy, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean optional, MetadataBuildingContext context) {
        XProperty property = inferredData.getProperty();
        Any value = new Any(context, keyColumns.getTable(), true);
        value.setLazy(lazy);
        value.setOnDeleteAction(onDeleteAction);
        BasicValueBinder discriminatorValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_DISCRIMINATOR, context);
        AnnotatedColumns discriminatorColumns = AnnotatedColumn.buildColumnOrFormulaFromAnnotation(discriminatorColumn, discriminatorFormula, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), context);
        assert (discriminatorColumns.getColumns().size() == 1);
        discriminatorColumns.setTable(value.getTable());
        discriminatorValueBinder.setColumns(discriminatorColumns);
        discriminatorValueBinder.setReturnedClassName(inferredData.getTypeName());
        discriminatorValueBinder.setType(property, property.getType(), null, null);
        BasicValue discriminatorDescriptor = discriminatorValueBinder.make();
        value.setDiscriminator(discriminatorDescriptor);
        discriminatorValueBinder.fillSimpleValue();
        AnnotatedColumn firstDiscriminatorColumn = discriminatorColumns.getColumns().get(0);
        firstDiscriminatorColumn.linkWithValue(discriminatorDescriptor);
        JavaType<?> discriminatorJavaType = discriminatorDescriptor.resolve().getRelationalJavaType();
        HashMap discriminatorValueMappings = new HashMap();
        BinderHelper.processAnyDiscriminatorValues(inferredData.getProperty(), valueMapping -> discriminatorValueMappings.put(discriminatorJavaType.wrap(valueMapping.discriminator(), null), valueMapping.entity()));
        value.setDiscriminatorValueMappings(discriminatorValueMappings);
        BasicValueBinder keyValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_KEY, context);
        List<AnnotatedJoinColumn> columns = keyColumns.getJoinColumns();
        assert (columns.size() == 1);
        keyColumns.setTable(value.getTable());
        keyValueBinder.setColumns(keyColumns);
        if (!optional) {
            for (AnnotatedJoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        keyValueBinder.setType(property, property.getType(), null, null);
        BasicValue keyDescriptor = keyValueBinder.make();
        value.setKey(keyDescriptor);
        keyValueBinder.fillSimpleValue();
        keyColumns.checkPropertyConsistency();
        columns.get(0).linkWithValue(keyDescriptor);
        return value;
    }

    private static void processAnyDiscriminatorValues(XProperty property, Consumer<AnyDiscriminatorValue> consumer) {
        AnyDiscriminatorValue valueAnn = HCANNHelper.findAnnotation(property, AnyDiscriminatorValue.class);
        if (valueAnn != null) {
            consumer.accept(valueAnn);
            return;
        }
        AnyDiscriminatorValues valuesAnn = HCANNHelper.findAnnotation(property, AnyDiscriminatorValues.class);
        if (valuesAnn != null) {
            for (AnyDiscriminatorValue discriminatorValue : valuesAnn.value()) {
                consumer.accept(discriminatorValue);
            }
        }
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass declaringClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) {
        boolean retrieve = false;
        if (declaringClass != null) {
            InheritanceState inheritanceState = inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + declaringClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                retrieve = true;
            }
        }
        if (retrieve) {
            return context.getMetadataCollector().getMappedSuperclass(context.getBootstrapContext().getReflectionManager().toClass(declaringClass));
        }
        return null;
    }

    public static String getPath(PropertyHolder holder, PropertyData property) {
        return StringHelper.qualify(holder.getPath(), property.getPropertyName());
    }

    static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        XClass mappedClass = buildingContext.getBootstrapContext().getReflectionManager().toXClass(propertyHolder.getPersistentClass().getMappedClass());
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        if (propertyHolder.isInIdClass()) {
            PropertyData propertyData = metadataCollector.getPropertyAnnotatedWithIdAndToOne(mappedClass, propertyName);
            return propertyData == null && buildingContext.getBuildingOptions().isSpecjProprietarySyntaxEnabled() ? metadataCollector.getPropertyAnnotatedWithMapsId(mappedClass, propertyName) : propertyData;
        }
        return metadataCollector.getPropertyAnnotatedWithMapsId(mappedClass, isId ? "" : propertyName);
    }

    public static Map<String, String> toAliasTableMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias alias : aliases) {
            if (!StringHelper.isNotEmpty(alias.table())) continue;
            ret.put(alias.alias(), alias.table());
        }
        return ret;
    }

    public static Map<String, String> toAliasEntityMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (SqlFragmentAlias alias : aliases) {
            if (alias.entity() == Void.TYPE) continue;
            result.put(alias.alias(), alias.entity().getName());
        }
        return result;
    }

    public static boolean hasToOneAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(OneToOne.class);
    }

    public static <T extends Annotation> T getOverridableAnnotation(XAnnotatedElement element, Class<T> annotationType, MetadataBuildingContext context) {
        Dialect dialect = context.getMetadataCollector().getDatabase().getDialect();
        Iterator annotations = Arrays.stream(element.getAnnotations()).flatMap(annotation -> {
            try {
                Method value = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
                Class<?> returnType = value.getReturnType();
                if (returnType.isArray() && returnType.getComponentType().isAnnotationPresent(Repeatable.class) && returnType.getComponentType().isAnnotationPresent(DialectOverride.OverridesAnnotation.class)) {
                    return Stream.of((Annotation[])value.invoke(annotation, new Object[0]));
                }
            }
            catch (NoSuchMethodException value) {
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
            return Stream.of(annotation);
        }).iterator();
        while (annotations.hasNext()) {
            Annotation annotation2 = (Annotation)annotations.next();
            Class<? extends Annotation> type = annotation2.annotationType();
            DialectOverride.OverridesAnnotation overridesAnnotation = type.getAnnotation(DialectOverride.OverridesAnnotation.class);
            if (overridesAnnotation == null || !overridesAnnotation.value().equals(annotationType)) continue;
            try {
                Class overrideDialect = (Class)type.getDeclaredMethod("dialect", new Class[0]).invoke((Object)annotation2, new Object[0]);
                if (!overrideDialect.isAssignableFrom(dialect.getClass())) continue;
                DialectOverride.Version before = (DialectOverride.Version)type.getDeclaredMethod("before", new Class[0]).invoke((Object)annotation2, new Object[0]);
                DialectOverride.Version sameOrAfter = (DialectOverride.Version)type.getDeclaredMethod("sameOrAfter", new Class[0]).invoke((Object)annotation2, new Object[0]);
                DatabaseVersion version = dialect.getVersion();
                if (!version.isBefore(before.major(), before.minor()) || !version.isSameOrAfter(sameOrAfter.major(), sameOrAfter.minor())) continue;
                return (T)((Annotation)type.getDeclaredMethod("override", new Class[0]).invoke((Object)annotation2, new Object[0]));
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
        }
        return element.getAnnotation(annotationType);
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        switch (fetch) {
            case EAGER: {
                return FetchMode.JOIN;
            }
            case LAZY: {
                return FetchMode.SELECT;
            }
        }
        throw new AssertionFailure("unknown fetch type: " + fetch);
    }

    private static CascadeType convertCascadeType(jakarta.persistence.CascadeType cascade) {
        switch (cascade) {
            case ALL: {
                return CascadeType.ALL;
            }
            case PERSIST: {
                return CascadeType.PERSIST;
            }
            case MERGE: {
                return CascadeType.MERGE;
            }
            case REMOVE: {
                return CascadeType.REMOVE;
            }
            case REFRESH: {
                return CascadeType.REFRESH;
            }
            case DETACH: {
                return CascadeType.DETACH;
            }
        }
        throw new AssertionFailure("unknown cascade type: " + cascade);
    }

    private static EnumSet<CascadeType> convertToHibernateCascadeType(jakarta.persistence.CascadeType[] ejbCascades) {
        EnumSet<CascadeType> cascadeTypes = EnumSet.noneOf(CascadeType.class);
        if (ejbCascades != null) {
            for (jakarta.persistence.CascadeType cascade : ejbCascades) {
                cascadeTypes.add(BinderHelper.convertCascadeType(cascade));
            }
        }
        return cascadeTypes;
    }

    public static String getCascadeStrategy(jakarta.persistence.CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation, boolean orphanRemoval, boolean forcePersist) {
        CascadeType[] hibernateCascades;
        EnumSet<CascadeType> cascadeTypes = BinderHelper.convertToHibernateCascadeType(ejbCascades);
        CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            cascadeTypes.addAll(Arrays.asList(hibernateCascades));
        }
        if (orphanRemoval) {
            cascadeTypes.add(CascadeType.DELETE_ORPHAN);
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (forcePersist) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        return BinderHelper.renderCascadeTypeList(cascadeTypes);
    }

    private static String renderCascadeTypeList(EnumSet<CascadeType> cascadeTypes) {
        StringBuilder cascade = new StringBuilder();
        for (CascadeType cascadeType : cascadeTypes) {
            switch (cascadeType) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case DETACH: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: 
                case REMOVE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    static boolean isGlobalGeneratorNameGlobal(MetadataBuildingContext context) {
        return context.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled();
    }

    static boolean isCompositeId(XClass entityClass, XProperty idProperty) {
        return entityClass.isAnnotationPresent(Embeddable.class) || idProperty.isAnnotationPresent(EmbeddedId.class);
    }

    public static boolean isDefault(XClass clazz, MetadataBuildingContext context) {
        return context.getBootstrapContext().getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static void checkMappedByType(String mappedBy, Value targetValue, String propertyName, PropertyHolder propertyHolder, Map<String, PersistentClass> persistentClasses) {
        ToOne toOne;
        if (targetValue instanceof Collection) {
            toOne = (ToOne)((Collection)targetValue).getElement();
        } else if (targetValue instanceof ToOne) {
            toOne = (ToOne)targetValue;
        } else {
            return;
        }
        String referencedEntityName = toOne.getReferencedEntityName();
        PersistentClass referencedClass = persistentClasses.get(referencedEntityName);
        for (PersistentClass ownerClass = propertyHolder.getPersistentClass(); ownerClass != null; ownerClass = ownerClass.getSuperPersistentClass()) {
            if (!BinderHelper.checkReferencedClass(ownerClass, referencedClass)) continue;
            return;
        }
        throw new AnnotationException("Association '" + StringHelper.qualify(propertyHolder.getPath(), propertyName) + "' is 'mappedBy' a property named '" + mappedBy + "' which references the wrong entity type '" + referencedEntityName + "', expected '" + propertyHolder.getEntityName() + "'");
    }

    private static boolean checkReferencedClass(PersistentClass ownerClass, PersistentClass referencedClass) {
        while (referencedClass != null) {
            if (ownerClass.getTable() == referencedClass.getTable()) {
                return true;
            }
            referencedClass = referencedClass.getSuperPersistentClass();
        }
        return false;
    }
}

