/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.Instantiator;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AggregateComponentBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CopyIdentifierComponentSecondPass;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EmbeddableBinder.class);

    static PropertyBinder createCompositeBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, AnnotatedColumns columns, XClass returnedClass, PropertyBinder propertyBinder, boolean isOverridden, Class<? extends CompositeUserType<?>> compositeUserType) {
        AnnotatedJoinColumns actualColumns;
        String propertyName;
        String referencedEntityName;
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            referencedEntityName = mapsIdProperty.getClassOrElementName();
            propertyName = mapsIdProperty.getPropertyName();
            AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
            parent.setBuildingContext(context);
            parent.setPropertyHolder(propertyHolder);
            parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            for (AnnotatedColumn column : columns.getColumns()) {
                column.setParent(parent);
            }
            actualColumns = parent;
        } else {
            referencedEntityName = null;
            propertyName = null;
            actualColumns = null;
        }
        return EmbeddableBinder.createEmbeddedProperty(inferredData, propertyHolder, entityBinder, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, EmbeddableBinder.bindEmbeddable(inferredData, propertyHolder, entityBinder.getPropertyAccessor(property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, referencedEntityName, propertyName, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, actualColumns, columns));
    }

    static boolean isEmbedded(XProperty property, XClass returnedClass) {
        return property.isAnnotationPresent(Embedded.class) || property.isAnnotationPresent(EmbeddedId.class) || returnedClass.isAnnotationPresent(Embeddable.class) && !property.isAnnotationPresent(Convert.class);
    }

    private static Component bindEmbeddable(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedJoinColumns columns, AnnotatedColumns annotatedColumns) {
        Component component;
        if (referencedEntityName != null) {
            component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
            context.getMetadataCollector().addSecondPass(new CopyIdentifierComponentSecondPass(component, referencedEntityName, propertyName, columns, context));
        } else {
            component = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, context.getMetadataCollector().isInSecondPass(), customInstantiatorImpl, compositeUserTypeClass, annotatedColumns, context, inheritanceStatePerClass);
        }
        if (isId) {
            component.setKey(true);
            EmbeddableBinder.checkEmbeddedId(inferredData, propertyHolder, referencedEntityName, component);
        }
        EmbeddableBinder.callTypeBinders(component, context, inferredData.getPropertyClass());
        return component;
    }

    private static void callTypeBinders(Component component, MetadataBuildingContext context, XClass annotatedClass) {
        for (Annotation containingAnnotation : HCANNHelper.findContainingAnnotations(annotatedClass, TypeBinderType.class)) {
            TypeBinderType binderType = containingAnnotation.annotationType().getAnnotation(TypeBinderType.class);
            try {
                TypeBinder<?> binder = binderType.binder().newInstance();
                binder.bind(containingAnnotation, context, component);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @TypeBinderType annotation '" + containingAnnotation + "'", e);
            }
        }
    }

    private static PropertyBinder createEmbeddedProperty(PropertyData inferredData, PropertyHolder propertyHolder, EntityBinder entityBinder, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, Component component) {
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(component);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(context);
        binder.makePropertyAndBind();
        return binder;
    }

    private static void checkEmbeddedId(PropertyData inferredData, PropertyHolder propertyHolder, String referencedEntityName, Component component) {
        if (propertyHolder.getPersistentClass().getIdentifier() != null) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
        }
        if (referencedEntityName == null && component.getPropertySpan() == 0) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
        }
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, columns, context, inheritanceStatePerClass, false);
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, boolean isIdClass) {
        XClass returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", (Object)subpath);
        PropertyHolder subholder = PropertyHolderBuilder.buildPropertyHolder(component, subpath, inferredData, propertyHolder, context);
        propertyHolder.startingProperty(inferredData.getProperty());
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrElement();
        } else {
            compositeUserType = EmbeddableBinder.compositeUserType(compositeUserTypeClass, context);
            component.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = context.getBootstrapContext().getReflectionManager().toXClass(compositeUserType.embeddable());
        }
        XClass annotatedClass = inferredData.getPropertyClass();
        List<PropertyData> classElements = EmbeddableBinder.collectClassElements(propertyAccessor, context, returnedClassOrElement, annotatedClass, isIdClass);
        List<PropertyData> baseClassElements = EmbeddableBinder.collectBaseClassElements(baseInferredData, propertyAccessor, context, annotatedClass);
        if (baseClassElements != null && !EmbeddableBinder.hasAnnotationsOnIdClass(annotatedClass)) {
            EmbeddableBinder.processIdClassElememts(propertyHolder, baseInferredData, classElements, baseClassElements);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            PropertyBinder.processElementAnnotations(subholder, entityBinder.getPersistentClass() instanceof SingleTableSubclass ? Nullability.FORCED_NULL : (isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL), propertyAnnotatedElement, new HashMap<String, IdentifierGeneratorDefinition>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            XProperty property = propertyAnnotatedElement.getProperty();
            if (!EmbeddableBinder.isGeneratedId(property)) continue;
            EmbeddableBinder.processGeneratedId(context, component, property);
        }
        if (compositeUserType != null) {
            EmbeddableBinder.processCompositeUserType(component, compositeUserType);
        }
        AggregateComponentBinder.processAggregate(component, propertyHolder, inferredData, returnedClassOrElement, columns, context);
        return component;
    }

    private static CompositeUserType<?> compositeUserType(Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext context) {
        if (context.getBuildingOptions().disallowExtensionsInCdi()) {
            FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(compositeUserTypeClass);
        }
        return context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(compositeUserTypeClass).getBeanInstance();
    }

    private static List<PropertyData> collectClassElements(AccessType propertyAccessor, MetadataBuildingContext context, XClass returnedClassOrElement, XClass annotatedClass, boolean isIdClass) {
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        PropertyContainer container = new PropertyContainer(returnedClassOrElement, annotatedClass, propertyAccessor);
        PropertyBinder.addElementsOfClass(classElements, container, context);
        for (XClass superClass = annotatedClass.getSuperclass(); superClass != null && (superClass.isAnnotationPresent(MappedSuperclass.class) || isIdClass && !Object.class.getName().equals(superClass.getName())); superClass = superClass.getSuperclass()) {
            PropertyContainer superContainer = new PropertyContainer(superClass, annotatedClass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context);
        }
        return classElements;
    }

    private static List<PropertyData> collectBaseClassElements(PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context, XClass annotatedClass) {
        if (baseInferredData != null) {
            ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                PropertyContainer container = new PropertyContainer(baseReturnedClassOrElement, annotatedClass, propertyAccessor);
                PropertyBinder.addElementsOfClass(baseClassElements, container, context);
                baseReturnedClassOrElement = baseReturnedClassOrElement.getSuperclass();
            }
            return baseClassElements;
        }
        return null;
    }

    private static boolean isGeneratedId(XProperty property) {
        return property.isAnnotationPresent(GeneratedValue.class) && property.isAnnotationPresent(Id.class);
    }

    private static void processCompositeUserType(Component component, CompositeUserType<?> compositeUserType) {
        component.sortProperties();
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(component.getPropertySpan());
        ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(component.getPropertySpan());
        PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
        for (Property property : component.getProperties()) {
            sortedPropertyNames.add(property.getName());
            sortedPropertyTypes.add(PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
            property.setPropertyAccessStrategy(strategy);
        }
    }

    private static boolean hasAnnotationsOnIdClass(XClass idClass) {
        for (XProperty property : idClass.getDeclaredProperties("field")) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(property)) continue;
            return true;
        }
        for (XMethod method : idClass.getDeclaredMethods()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(Column.class) || property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(GeneratedValue.class) || property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(ManyToMany.class);
    }

    private static void processGeneratedId(MetadataBuildingContext context, Component component, XProperty property) {
        String generator;
        GeneratedValue generatedValue = property.getAnnotation(GeneratedValue.class);
        String generatorType = generatedValue != null ? GeneratorBinder.generatorType(generatedValue, property.getType(), context) : "assigned";
        String string = generator = generatedValue != null ? generatedValue.generator() : "";
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            GeneratorBinder.buildGenerators(property, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context));
        } else {
            GeneratorBinder.makeIdGenerator((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context, new HashMap<String, IdentifierGeneratorDefinition>(GeneratorBinder.buildGenerators(property, context)));
        }
    }

    private static void processIdClassElememts(PropertyHolder propertyHolder, PropertyData baseInferredData, List<PropertyData> classElements, List<PropertyData> baseClassElements) {
        HashMap<String, PropertyData> baseClassElementsByName = new HashMap<String, PropertyData>();
        for (PropertyData element : baseClassElements) {
            baseClassElementsByName.put(element.getPropertyName(), element);
        }
        for (int i = 0; i < classElements.size(); ++i) {
            PropertyData idClassPropertyData = classElements.get(i);
            PropertyData entityPropertyData = (PropertyData)baseClassElementsByName.get(idClassPropertyData.getPropertyName());
            if (propertyHolder.isInIdClass()) {
                if (entityPropertyData == null) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyClass().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                }
                if (BinderHelper.hasToOneAnnotation(entityPropertyData.getProperty()) && !entityPropertyData.getClassOrElement().equals(idClassPropertyData.getClassOrElement())) continue;
            }
            classElements.set(i, entityPropertyData);
        }
    }

    static Component createEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        Component component = new Component(context, propertyHolder.getPersistentClass());
        component.setEmbedded(isComponentEmbedded);
        component.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
        } else {
            component.setComponentClassName(inferredData.getClassOrElementName());
        }
        component.setCustomInstantiator(customInstantiatorImpl);
        Constructor<?> constructor = EmbeddableBinder.resolveInstantiator(inferredData.getClassOrElement(), context);
        if (constructor != null) {
            component.setInstantiator(constructor, constructor.getAnnotation(Instantiator.class).value());
        }
        return component;
    }

    private static Constructor<?> resolveInstantiator(XClass embeddableClass, MetadataBuildingContext buildingContext) {
        if (embeddableClass != null) {
            Constructor<?>[] declaredConstructors = buildingContext.getBootstrapContext().getReflectionManager().toClass(embeddableClass).getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredConstructor : declaredConstructors) {
                if (!declaredConstructor.isAnnotationPresent(Instantiator.class)) continue;
                if (constructor != null) {
                    throw new AnnotationException("Multiple constructors of '" + embeddableClass.getName() + "' are annotated '@Instantiator' but only one constructor can be the canonical constructor");
                }
                constructor = declaredConstructor;
            }
            return constructor;
        }
        return null;
    }

    private static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (property.isAnnotationPresent(EmbeddedId.class)) {
            return null;
        }
        EmbeddableInstantiator propertyAnnotation = property.getAnnotation(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = returnedClass.getAnnotation(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        Class embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass);
        if (embeddableClass != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(embeddableClass);
        }
        return null;
    }
}

