/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionId;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BagBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.WrappedInferredData;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;

public class IdBagBinder
extends BagBinder {
    public IdBagBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, buildingContext);
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new IdentifierBag(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    protected boolean bindStarToManySecondPass(Map<String, PersistentClass> persistentClasses) {
        String generatorName;
        String generatorType;
        String namedGenerator;
        boolean result = super.bindStarToManySecondPass(persistentClasses);
        CollectionId collectionIdAnn = this.property.getAnnotation(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing '@CollectionId' annotation");
        }
        WrappedInferredData propertyData = new WrappedInferredData(new PropertyInferredData(null, this.property, null, this.buildingContext.getBootstrapContext().getReflectionManager()), "id");
        AnnotatedColumns idColumns = AnnotatedColumn.buildColumnsFromAnnotations(new Column[]{collectionIdAnn.column()}, Nullability.FORCED_NOT_NULL, this.propertyHolder, propertyData, Collections.emptyMap(), this.buildingContext);
        for (AnnotatedColumn idColumn : idColumns.getColumns()) {
            idColumn.setNullable(false);
        }
        BasicValueBinder valueBinder = new BasicValueBinder(BasicValueBinder.Kind.COLLECTION_ID, this.buildingContext);
        Table table = this.collection.getCollectionTable();
        valueBinder.setTable(table);
        valueBinder.setColumns(idColumns);
        valueBinder.setType(this.property, this.getElementType(), null, null);
        BasicValue id = valueBinder.make();
        ((IdentifierCollection)this.collection).setIdentifier(id);
        switch (namedGenerator = collectionIdAnn.generator()) {
            case "identity": {
                throw new MappingException("IDENTITY generation not supported for CollectionId");
            }
            case "assigned": {
                throw new MappingException("Assigned generation not supported for CollectionId");
            }
            case "native": {
                throw new MappingException("Native generation not supported for CollectionId");
            }
        }
        if ("sequence".equals(namedGenerator)) {
            generatorType = namedGenerator;
            generatorName = "";
        } else if ("increment".equals(namedGenerator)) {
            generatorType = namedGenerator;
            generatorName = "";
        } else {
            generatorType = namedGenerator;
            generatorName = namedGenerator;
        }
        id.setIdentifierGeneratorStrategy(generatorType);
        if (this.buildingContext.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass(id, this.property, generatorType, generatorName, this.getBuildingContext());
            this.buildingContext.getMetadataCollector().addSecondPass(secondPass);
        } else {
            GeneratorBinder.makeIdGenerator((SimpleValue)id, this.property, generatorType, generatorName, this.getBuildingContext(), this.localGenerators);
        }
        return result;
    }
}

