/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.MapKeyJoinColumns;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.MapKeyCompositeType;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.CollectionSecondPass;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantBasicValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserCollectionType;

public class MapBinder
extends CollectionBinder {
    public MapBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, boolean sorted, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, sorted, buildingContext);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    private Map getMap() {
        return (Map)this.collection;
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new Map(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    SecondPass getSecondPass() {
        return new CollectionSecondPass(this.collection){

            @Override
            public void secondPass(java.util.Map<String, PersistentClass> persistentClasses) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(persistentClasses);
                MapBinder.this.bindKeyFromAssociationTable(MapBinder.this.getElementType(), persistentClasses, MapBinder.this.hasMapKeyProperty, MapBinder.this.mapKeyPropertyName, MapBinder.this.property, MapBinder.this.isEmbedded, MapBinder.this.mapKeyColumns, MapBinder.this.mapKeyManyToManyColumns);
                MapBinder.this.makeOneToManyMapKeyColumnNullableIfNotInProperty(MapBinder.this.property);
            }
        };
    }

    private void makeOneToManyMapKeyColumnNullableIfNotInProperty(XProperty property) {
        Map map = (Map)this.collection;
        if (map.isOneToMany() && property.isAnnotationPresent(MapKeyColumn.class)) {
            PersistentClass persistentClass;
            Value indexValue = map.getIndex();
            if (indexValue.getColumnSpan() != 1) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn does not have 1 column");
            }
            Selectable selectable = indexValue.getSelectables().get(0);
            if (selectable.isFormula()) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn is a Formula");
            }
            Column column = (Column)selectable;
            if (!column.isNullable() && !this.propertiesContainColumn((persistentClass = ((OneToMany)map.getElement()).getAssociatedClass()).getUnjoinedProperties(), column)) {
                column.setNullable(true);
            }
        }
    }

    private boolean propertiesContainColumn(List<Property> properties, Column column) {
        for (Property property : properties) {
            for (Selectable selectable : property.getSelectables()) {
                if (!column.equals(selectable)) continue;
                Column iteratedColumn = (Column)selectable;
                if (!column.getValue().getTable().equals(iteratedColumn.getValue().getTable())) continue;
                return true;
            }
        }
        return false;
    }

    private void bindKeyFromAssociationTable(XClass elementType, java.util.Map<String, PersistentClass> persistentClasses, boolean hasMapKeyProperty, String mapKeyPropertyName, XProperty property, boolean isEmbedded, AnnotatedColumns mapKeyColumns, AnnotatedJoinColumns mapKeyManyToManyColumns) {
        if (hasMapKeyProperty) {
            this.handleMapKeyProperty(elementType, persistentClasses, mapKeyPropertyName);
        } else {
            this.handleMapKey(persistentClasses, property, isEmbedded, mapKeyColumns, mapKeyManyToManyColumns);
        }
    }

    private void handleMapKey(java.util.Map<String, PersistentClass> persistentClasses, XProperty property, boolean isEmbedded, AnnotatedColumns mapKeyColumns, AnnotatedJoinColumns mapKeyManyToManyColumns) {
        boolean isKeyedByEntities;
        String mapKeyType = MapBinder.getKeyType(property);
        PersistentClass collectionEntity = persistentClasses.get(mapKeyType);
        boolean bl = isKeyedByEntities = collectionEntity != null;
        if (isKeyedByEntities) {
            ManyToOne element = this.handleCollectionKeyedByEntities(mapKeyType);
            this.handleForeignKey(property, element);
            this.bindManyToManyInverseForeignKey(collectionEntity, mapKeyManyToManyColumns, element, false);
        } else {
            XClass keyClass = this.mapKeyClass(mapKeyType);
            this.handleMapKey(property, mapKeyColumns, mapKeyType, keyClass, this.annotatedMapKeyType(property, isEmbedded, mapKeyType, keyClass), this.buildCollectionPropertyHolder(property, keyClass), MapBinder.accessType(property, this.collection.getOwner()));
        }
        if (!this.collection.isOneToMany()) {
            for (AnnotatedJoinColumn column : mapKeyManyToManyColumns.getJoinColumns()) {
                column.forceNotNull();
            }
        }
    }

    private AnnotatedClassType annotatedMapKeyType(XProperty property, boolean isEmbedded, String mapKeyType, XClass keyClass) {
        if (BinderHelper.isPrimitive(mapKeyType)) {
            return AnnotatedClassType.NONE;
        }
        return isEmbedded || this.mappingDefinedAttributeOverrideOnMapKey(property) ? AnnotatedClassType.EMBEDDABLE : this.buildingContext.getMetadataCollector().getClassType(keyClass);
    }

    private XClass mapKeyClass(String mapKeyType) {
        if (BinderHelper.isPrimitive(mapKeyType)) {
            return null;
        }
        BootstrapContext bootstrapContext = this.buildingContext.getBootstrapContext();
        Class mapKeyClass = bootstrapContext.getClassLoaderAccess().classForName(mapKeyType);
        return bootstrapContext.getReflectionManager().toXClass(mapKeyClass);
    }

    private static String getKeyType(XProperty property) {
        Class target = property.isAnnotationPresent(MapKeyClass.class) ? property.getAnnotation(MapKeyClass.class).value() : Void.TYPE;
        return Void.TYPE.equals(target) ? property.getMapKey().getName() : target.getName();
    }

    private void handleMapKeyProperty(XClass elementType, java.util.Map<String, PersistentClass> persistentClasses, String mapKeyPropertyName) {
        PersistentClass associatedClass = persistentClasses.get(elementType.getName());
        if (associatedClass == null) {
            throw new AnnotationException("Association '" + this.safeCollectionRole() + "' targets the type '" + elementType.getName() + "' which is not an '@Entity' type");
        }
        Property mapProperty = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
        if (mapProperty == null) {
            throw new AnnotationException("Map key property '" + mapKeyPropertyName + "' not found in target entity '" + associatedClass.getEntityName() + "'");
        }
        InheritanceState inheritanceState = (InheritanceState)this.inheritanceStatePerClass.get(elementType);
        PersistentClass targetEntity = InheritanceType.JOINED == inheritanceState.getType() ? mapProperty.getPersistentClass() : associatedClass;
        Value indexValue = this.createFormulatedValue(mapProperty.getValue(), this.collection, associatedClass, targetEntity);
        this.getMap().setIndex(indexValue);
        this.getMap().setMapKeyPropertyName(mapProperty.getName());
    }

    private CollectionPropertyHolder buildCollectionPropertyHolder(XProperty property, XClass keyClass) {
        CollectionPropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(this.collection, StringHelper.qualify(this.collection.getRole(), "mapkey"), keyClass, property, this.propertyHolder, this.buildingContext);
        this.propertyHolder.startingProperty(property);
        holder.prepare(property, !(this.collection.getKey().getType() instanceof BasicType));
        return holder;
    }

    private void handleForeignKey(XProperty property, ManyToOne element) {
        ForeignKey foreignKey = this.getMapKeyForeignKey(property);
        if (foreignKey != null) {
            ConstraintMode constraintMode = foreignKey.value();
            if (constraintMode == ConstraintMode.NO_CONSTRAINT || constraintMode == ConstraintMode.PROVIDER_DEFAULT && this.getBuildingContext().getBuildingOptions().isNoConstraintByDefault()) {
                element.disableForeignKey();
            } else {
                element.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                element.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
            }
        }
    }

    private ManyToOne handleCollectionKeyedByEntities(String mapKeyType) {
        ManyToOne element = new ManyToOne(this.buildingContext, this.collection.getCollectionTable());
        this.getMap().setIndex(element);
        element.setReferencedEntityName(mapKeyType);
        element.setFetchMode(FetchMode.JOIN);
        element.setLazy(false);
        return element;
    }

    private void handleMapKey(XProperty property, AnnotatedColumns mapKeyColumns, String mapKeyType, XClass keyClass, AnnotatedClassType classType, CollectionPropertyHolder holder, AccessType accessType) {
        Class<? extends CompositeUserType<?>> compositeUserType = MapBinder.resolveCompositeUserType(property, keyClass, this.buildingContext);
        if (classType == AnnotatedClassType.EMBEDDABLE || compositeUserType != null) {
            this.handleCompositeMapKey(keyClass, holder, accessType, compositeUserType);
        } else {
            this.handleMapKey(property, mapKeyColumns, mapKeyType, keyClass, holder, accessType);
        }
    }

    private void handleMapKey(XProperty property, AnnotatedColumns mapKeyColumns, String mapKeyType, XClass keyClass, CollectionPropertyHolder holder, AccessType accessType) {
        BasicValueBinder elementBinder = new BasicValueBinder(BasicValueBinder.Kind.MAP_KEY, this.buildingContext);
        elementBinder.setReturnedClassName(mapKeyType);
        AnnotatedColumns keyColumns = MapBinder.createElementColumnsIfNecessary(this.collection, mapKeyColumns, "id", 255L, this.buildingContext);
        elementBinder.setColumns(keyColumns);
        elementBinder.setType(property, keyClass, this.collection.getOwnerEntityName(), holder.mapKeyAttributeConverterDescriptor(property, keyClass));
        elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
        elementBinder.setAccessType(accessType);
        this.getMap().setIndex(elementBinder.make());
    }

    private void handleCompositeMapKey(XClass keyClass, CollectionPropertyHolder holder, AccessType accessType, Class<? extends CompositeUserType<?>> compositeUserType) {
        this.getMap().setIndex(EmbeddableBinder.fillEmbeddable(holder, this.propertyPreloadedData(keyClass), accessType, true, new EntityBinder(), false, false, true, null, compositeUserType, null, this.buildingContext, this.inheritanceStatePerClass));
    }

    private PropertyPreloadedData propertyPreloadedData(XClass keyClass) {
        return this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "index", keyClass) : new PropertyPreloadedData(AccessType.PROPERTY, "key", keyClass);
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        Class embeddableClass;
        MapKeyCompositeType compositeType = property.getAnnotation(MapKeyCompositeType.class);
        if (compositeType != null) {
            return compositeType.value();
        }
        if (returnedClass != null && (embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass)) != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private ForeignKey getMapKeyForeignKey(XProperty property) {
        MapKeyJoinColumns mapKeyJoinColumns = property.getAnnotation(MapKeyJoinColumns.class);
        MapKeyJoinColumn mapKeyJoinColumn = property.getAnnotation(MapKeyJoinColumn.class);
        if (mapKeyJoinColumns != null) {
            return mapKeyJoinColumns.foreignKey();
        }
        if (mapKeyJoinColumn != null) {
            return mapKeyJoinColumn.foreignKey();
        }
        return null;
    }

    private boolean mappingDefinedAttributeOverrideOnMapKey(XProperty property) {
        if (property.isAnnotationPresent(AttributeOverride.class)) {
            return this.namedMapKey(property.getAnnotation(AttributeOverride.class));
        }
        if (property.isAnnotationPresent(AttributeOverrides.class)) {
            AttributeOverrides annotations = property.getAnnotation(AttributeOverrides.class);
            for (AttributeOverride attributeOverride : annotations.value()) {
                if (!this.namedMapKey(attributeOverride)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean namedMapKey(AttributeOverride annotation) {
        return annotation.name().startsWith("key.");
    }

    private Value createFormulatedValue(Value value, Collection collection, PersistentClass associatedClass, PersistentClass targetPropertyPersistentClass) {
        Table mapKeyTable;
        if (value instanceof Component) {
            return this.createIndexComponent(collection, associatedClass, (Component)value);
        }
        Table table = mapKeyTable = !associatedClass.equals(targetPropertyPersistentClass) ? targetPropertyPersistentClass.getTable() : associatedClass.getTable();
        if (value instanceof BasicValue) {
            return this.createDependantBasicValue(mapKeyTable, (BasicValue)value);
        }
        if (value instanceof SimpleValue) {
            return this.createTargetValue(mapKeyTable, (SimpleValue)value);
        }
        throw new AssertionFailure("Unknown type encountered for map key: " + value.getClass());
    }

    private SimpleValue createTargetValue(Table mapKeyTable, SimpleValue sourceValue) {
        SimpleValue targetValue;
        if (sourceValue instanceof ManyToOne) {
            ManyToOne sourceManyToOne = (ManyToOne)sourceValue;
            ManyToOne targetManyToOne = new ManyToOne(this.getBuildingContext(), mapKeyTable);
            targetManyToOne.setFetchMode(FetchMode.DEFAULT);
            targetManyToOne.setLazy(true);
            targetManyToOne.setReferencedEntityName(sourceManyToOne.getReferencedEntityName());
            targetValue = targetManyToOne;
        } else {
            targetValue = new BasicValue(this.getBuildingContext(), mapKeyTable);
            ((SimpleValue)targetValue).copyTypeFrom(sourceValue);
        }
        for (Selectable selectable : sourceValue.getSelectables()) {
            MapBinder.addSelectable(targetValue, selectable);
        }
        return targetValue;
    }

    private DependantBasicValue createDependantBasicValue(Table mapKeyTable, BasicValue sourceValue) {
        DependantBasicValue dependantBasicValue = new DependantBasicValue(this.getBuildingContext(), mapKeyTable, sourceValue, false, false);
        MapBinder.addSelectable(dependantBasicValue, sourceValue.getColumn());
        return dependantBasicValue;
    }

    private static void addSelectable(SimpleValue targetValue, Selectable selectable) {
        if (selectable instanceof Column) {
            targetValue.addColumn(((Column)selectable).clone(), false, false);
        } else if (selectable instanceof Formula) {
            targetValue.addFormula(new Formula(((Formula)selectable).getFormula()));
        } else {
            throw new AssertionFailure("Unknown element in column iterator: " + selectable.getClass());
        }
    }

    private Component createIndexComponent(Collection collection, PersistentClass associatedClass, Component component) {
        Component indexComponent = new Component(this.getBuildingContext(), collection);
        indexComponent.setComponentClassName(component.getComponentClassName());
        for (Property property : component.getProperties()) {
            Property newProperty = new Property();
            newProperty.setCascade(property.getCascade());
            newProperty.setValueGeneratorCreator(property.getValueGeneratorCreator());
            newProperty.setInsertable(false);
            newProperty.setUpdateable(false);
            newProperty.setMetaAttributes(property.getMetaAttributes());
            newProperty.setName(property.getName());
            newProperty.setNaturalIdentifier(false);
            newProperty.setOptional(false);
            newProperty.setPersistentClass(property.getPersistentClass());
            newProperty.setPropertyAccessorName(property.getPropertyAccessorName());
            newProperty.setSelectable(property.isSelectable());
            newProperty.setValue(this.createFormulatedValue(property.getValue(), collection, associatedClass, associatedClass));
            indexComponent.addProperty(newProperty);
        }
        return indexComponent;
    }
}

